/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.log4j.Logger;

public class VixTimeSpecifier {
    private static Logger gLogger = Logger.getLogger(VixTimeSpecifier.class);
    static final String VALUE_MTIME = "mtime";
    static final String FORMAT_EPOCH = "epoch";
    Pattern _regex = null;
    String _format = null;
    String _value = null;
    long _offset = 0L;
    long _longValue = 0L;
    SimpleDateFormat _timeFormat = null;
    TimeZone _tz = null;

    VixTimeSpecifier(String regex, String format, String value, String offset, String timezone) {
        this._format = format;
        if (regex != null) {
            this._regex = Pattern.compile(regex);
            if (format != null && !format.equalsIgnoreCase(FORMAT_EPOCH)) {
                this._timeFormat = new SimpleDateFormat(format);
            }
        } else if (value != null) {
            this._value = value;
            if (this._value.equalsIgnoreCase(VALUE_MTIME)) {
                this._value = VALUE_MTIME;
            } else {
                this._longValue = Long.parseLong(this._value);
            }
        }
        if (this._timeFormat != null && timezone != null && !timezone.trim().isEmpty()) {
            this._tz = TimeZone.getTimeZone(timezone.trim());
            this._timeFormat.setTimeZone(this._tz);
        }
        if (this._timeFormat != null) {
            this._tz = this._timeFormat.getTimeZone();
            gLogger.info((Object)("using timezone=" + timezone + ", _tz.id=\"" + this._tz.getID() + "\", name=\"" + this._tz.getDisplayName() + "\" for regex=" + regex + ", format=" + format));
        }
        if (offset != null) {
            try {
                this._offset = Long.parseLong(offset);
            }
            catch (Exception e) {
                gLogger.warn((Object)("Failed to convert offset [" + offset + "] to long integer"), (Throwable)e);
            }
        }
    }

    public long getTime(FileStatus file, long defaultValue) {
        long result = this.getTimeImpl(file) / 1000L;
        return result == 0L ? defaultValue : result + this._offset;
    }

    protected long getTimeImpl(FileStatus file) {
        if (this._value == VALUE_MTIME) {
            return file.getModificationTime();
        }
        if (this._value != null) {
            return this._longValue;
        }
        if (this._regex != null) {
            Matcher m;
            String path = file.getPath().toUri().getPath();
            if (file.isDir() && !path.endsWith("/")) {
                path = path + "/";
            }
            if ((m = this._regex.matcher(path)).find()) {
                StringBuilder timeStr = new StringBuilder();
                for (int i = 0; i < m.groupCount(); ++i) {
                    timeStr.append(m.group(i + 1));
                }
                if (this._timeFormat != null) {
                    try {
                        Date d = this._timeFormat.parse(timeStr.toString());
                        return d.getTime();
                    }
                    catch (ParseException e) {
                        gLogger.warn((Object)("Failed to parse timeStr [" + timeStr.toString() + "] with format [" + this._timeFormat.toPattern() + "]"), (Throwable)e);
                        return 0L;
                    }
                }
                if (FORMAT_EPOCH.equalsIgnoreCase(this._format)) {
                    try {
                        return Long.parseLong(timeStr.toString()) * 1000L;
                    }
                    catch (Exception e) {
                        gLogger.warn((Object)("Failed to convert timeStr [" + timeStr.toString() + "] to long integer"), (Throwable)e);
                    }
                }
            } else if (!file.isDir()) {
                gLogger.warn((Object)String.format("Could not match time regex=\"%s\" against path=\"%s\"", this._regex.pattern(), file.getPath().toUri().getPath()));
            }
        }
        return 0L;
    }
}

