/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.util.HdfsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class CompactionMetadata {
    private static final Logger gLogger = Logger.getLogger(CompactionMetadata.class);
    public static final String METADATA_FILE_NAME_PREFIX = "meta_";
    public static final String METADATA_FILE_NAME_SUFFIX = ".json";
    private static final int NO_LATEST_TIMES_FOUND = -1;
    private static final String SPLIT_COUNT = "sc";
    private static final String EARLIEST_TIME = "et";
    private static final String LATEST_TIME = "lt";
    private static final String TOTAL_SPLIT_SIZE = "ss";
    private final Date latestTime;
    private final Date earliestTime;
    private final long splitCount;
    private final long totalSplitSize;

    public CompactionMetadata(Date latestTime, Date earliestTime, long splitCount, long totalSplitSize) {
        this.latestTime = latestTime;
        this.earliestTime = earliestTime;
        this.splitCount = splitCount;
        this.totalSplitSize = totalSplitSize;
    }

    public Date getLatestTime() {
        return this.latestTime;
    }

    public Date getEarliestTime() {
        return this.earliestTime;
    }

    public long getSplitCount() {
        return this.splitCount;
    }

    public long getTotalSplitSize() {
        return this.totalSplitSize;
    }

    public CompactionMetadata mergeWith(CompactionMetadata meta) {
        Date lt = this.latestTime.after(meta.latestTime) ? this.latestTime : meta.latestTime;
        Date et = this.earliestTime.before(meta.earliestTime) ? this.earliestTime : meta.earliestTime;
        long sc = this.splitCount + meta.splitCount;
        long tss = this.totalSplitSize + meta.totalSplitSize;
        return new CompactionMetadata(lt, et, sc, tss);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(LATEST_TIME, this.latestTime.getTime());
        map.put(EARLIEST_TIME, this.earliestTime.getTime());
        map.put(SPLIT_COUNT, this.splitCount);
        map.put(TOTAL_SPLIT_SIZE, this.totalSplitSize);
        return map;
    }

    public static CompactionMetadata fromMap(Map<String, Object> map) {
        Date lt = new Date(CompactionMetadata.l(map.get(LATEST_TIME)));
        Date et = new Date(CompactionMetadata.l(map.get(EARLIEST_TIME)));
        long sc = CompactionMetadata.l(map.get(SPLIT_COUNT));
        long tss = CompactionMetadata.l(map.get(TOTAL_SPLIT_SIZE));
        return new CompactionMetadata(lt, et, sc, tss);
    }

    private static long l(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return (Long)o;
    }

    private static Path getMetadataFile(Path compactionDir, CompactionMetadata meta) {
        return new Path(compactionDir, METADATA_FILE_NAME_PREFIX + meta.getLatestTime().getTime() + METADATA_FILE_NAME_SUFFIX);
    }

    private static Date getLatestTimeFromFile(Path metadataFile) {
        String filenameData = StringUtils.substringBetween((String)metadataFile.getName(), (String)METADATA_FILE_NAME_PREFIX, (String)METADATA_FILE_NAME_SUFFIX);
        long latestTime = Long.parseLong(filenameData);
        return new Date(latestTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompactionMetadata(FileSystem fs, Path compactionPath, CompactionMetadata meta) throws IOException {
        fs.mkdirs(compactionPath);
        FSDataOutputStream open = null;
        try {
            Path file = CompactionMetadata.getMetadataFile(compactionPath, meta);
            byte[] json = new ObjectMapper().writeValueAsBytes(meta.toMap());
            open = fs.create(file, true);
            IOUtils.write((byte[])json, (OutputStream)open);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(open);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)open);
    }

    public static CompactionMetadata getMetadata(FileSystem fs, Path compactionPath) throws IOException {
        FileStatus[] metadataFiles = CompactionMetadata.findMetadataFiles(fs, compactionPath);
        if (metadataFiles.length == 0) {
            gLogger.info((Object)("No metadata was found for compaction=" + compactionPath + ". Using a NullObject for this compaction, meaning that the info probing for this compaction will have wrong results."));
            return new Null();
        }
        return CompactionMetadata.readMetadataFiles(fs, compactionPath, metadataFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompactionMetadata readMetadataFiles(FileSystem fs, Path compactionPath, FileStatus[] metadataFiles) throws IOException, JsonParseException, JsonMappingException {
        if (metadataFiles.length > 1) {
            gLogger.debug((Object)("More than one metadata file was found for compaction=" + compactionPath + ". Returning a merged data using all the files."));
        }
        CompactionMetadata ret = new Zero();
        for (FileStatus metadataFile : metadataFiles) {
            FSDataInputStream in = null;
            try {
                in = fs.open(metadataFile.getPath());
                Map map = (Map)new ObjectMapper().readValue((InputStream)in, Map.class);
                CompactionMetadata meta = CompactionMetadata.fromMap(map);
                ret = ret.mergeWith(meta);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        return ret;
    }

    public static Date getCompactionLatestTime(FileSystem fs, Path compactionPath) throws IOException, CompactionLtNotFoundException {
        FileStatus[] statuses = CompactionMetadata.findMetadataFiles(fs, compactionPath);
        if (statuses.length > 1) {
            gLogger.warn((Object)("More than one metadata file for compaction=" + compactionPath + ". Choosing the latest time"));
        }
        long latestTime = -1L;
        for (FileStatus status : statuses) {
            try {
                latestTime = Math.max(latestTime, CompactionMetadata.getLatestTimeFromFile(status.getPath()).getTime());
            }
            catch (Exception ignore) {
                gLogger.debug((Object)("Found malformed metadata file=" + status.getPath().getName() + ". Ignoring"));
            }
        }
        if (latestTime != -1L) {
            return new Date(latestTime);
        }
        String message = "No latest time was found for compaction=" + compactionPath;
        gLogger.warn((Object)message);
        throw new CompactionLtNotFoundException(message);
    }

    private static FileStatus[] findMetadataFiles(FileSystem fs, Path compactionPath) throws IOException {
        return HdfsUtil.ls(fs, compactionPath, new PathFilter(){

            public boolean accept(Path path) {
                String filename = path.getName();
                return filename.startsWith(CompactionMetadata.METADATA_FILE_NAME_PREFIX) && filename.endsWith(CompactionMetadata.METADATA_FILE_NAME_SUFFIX);
            }
        });
    }

    public static class CompactionLtNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CompactionLtNotFoundException(String message) {
            super(message);
        }
    }

    public static class Null
    extends CompactionMetadata {
        public Null() {
            super(new Date(Long.MAX_VALUE), new Date(0L), 0L, 0L);
        }
    }

    public static class Zero
    extends CompactionMetadata {
        public Zero() {
            super(new Date(0L), new Date(Long.MAX_VALUE), 0L, 0L);
        }
    }
}

