/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class PTFUtils {
    public static String toString(List<?> col) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean first = true;
        for (Object o : col) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(o.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(Map<?, ?> col) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean first = true;
        for (Map.Entry<?, ?> o : col.entrySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(o.getKey().toString()).append(" : ").append(o.getValue().toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public static String unescapeQueryString(String qry) {
        qry = qry.replace("\\\"", "\"");
        qry = qry.replace("\\'", "'");
        return qry;
    }

    public static abstract class Predicate<T> {
        public abstract boolean apply(T var1);
    }

    public static class ReverseIterator<T>
    implements Iterator<T> {
        Stack<T> stack = new Stack();

        public ReverseIterator(Iterator<T> it) {
            while (it.hasNext()) {
                this.stack.push(it.next());
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public T next() {
            return this.stack.pop();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

