/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public class HdfsUtil {
    private static final Logger gLogger = Logger.getLogger(HdfsUtil.class);
    private static final FileStatus[] EMPTY_LS = new FileStatus[0];

    private static String normalizePath(Path path, boolean dropScheme) {
        if (path == null) {
            return null;
        }
        String p = path.toString();
        if (dropScheme) {
            p = path.toUri().getPath();
        }
        if (p.equals("/")) {
            return p;
        }
        if (p.endsWith("/")) {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    public static boolean containsPath(Path longPath, Path shortPath) {
        return HdfsUtil.containsPath(longPath, shortPath, false);
    }

    public static boolean containsPath(Path longPath, Path shortPath, boolean ignoreScheme) {
        if (longPath == null || shortPath == null) {
            return false;
        }
        String lPath = HdfsUtil.normalizePath(longPath, ignoreScheme);
        String sPath = HdfsUtil.normalizePath(shortPath, ignoreScheme);
        return lPath.startsWith(sPath);
    }

    public static boolean equalPath(Path p1, Path p2) {
        return HdfsUtil.equalPath(p1, p2, false);
    }

    public static boolean equalPath(Path p1, Path p2, boolean ignoreScheme) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null && p2 != null) {
            return false;
        }
        if (p1 != null && p2 == null) {
            return false;
        }
        String lp = HdfsUtil.normalizePath(p1, ignoreScheme);
        String rp = HdfsUtil.normalizePath(p2, ignoreScheme);
        return lp.equals(rp);
    }

    public static FileStatus[] ls(FileSystem fs, Path p) throws IOException {
        try {
            return HdfsUtil.nullSafe(fs.listStatus(p));
        }
        catch (Exception e) {
            HdfsUtil.logException(p, e);
            return EMPTY_LS;
        }
    }

    public static FileStatus[] ls(FileSystem fs, Path p, PathFilter filter) throws IOException {
        try {
            return HdfsUtil.nullSafe(fs.listStatus(p, filter));
        }
        catch (Exception e) {
            HdfsUtil.logException(p, e);
            return EMPTY_LS;
        }
    }

    private static FileStatus[] nullSafe(FileStatus[] fileStatus) {
        if (fileStatus != null) {
            return fileStatus;
        }
        return EMPTY_LS;
    }

    private static void logException(Path p, Exception e) {
        gLogger.debug((Object)("Exception when listing filesystem with path=" + p + ", exception=" + e));
    }
}

