/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.s2s;

import com.splunk.s2s.Channel;
import com.splunk.s2s.ReadableV4;
import com.splunk.s2s.S2SLong;
import com.splunk.s2s.S2SString;
import com.splunk.s2s.S2SUtil;
import com.splunk.s2s.S2SValue;
import com.splunk.s2s.StreamingS2S;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Event
implements ReadableV4 {
    static final BigDecimal ONE_THOUSAND = BigDecimal.valueOf(1000L);
    Channel _chan = null;
    int _flags = 0;
    Number _time = null;
    Number _nonNullTime = null;
    long _ackId = -1L;
    S2SString _raw = null;
    ArrayList<KVPair> _fields = null;
    S2SString _index = null;
    public static final S2SString FIELD_KEY_PATH = new S2SString("_path");
    public static final S2SString FIELD_INDEX = new S2SString("_MetaData:Index");
    public static final S2SString FIELD_SUBSECOND = new S2SString("_subsecond");

    public Event() {
    }

    public Event(long ackId, Channel channel, Map<String, String> fields, int flags, String index, String raw, Long time) {
        this._ackId = ackId;
        this._chan = channel;
        this._flags = flags;
        this._index = new S2SString(index);
        this._raw = new S2SString(raw);
        this._time = time;
        this._nonNullTime = null == this._time ? this.getCurrentTime() : this._time;
        this._fields = new ArrayList();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            KVPair pair = new KVPair(new S2SString(entry.getKey()), new S2SString(entry.getValue()));
            this._fields.add(pair);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("event: {channelId=").append(this._chan == null ? -1L : this._chan.getId());
        sb.append(", _flags=").append(this._flags);
        if (this._ackId > -1L) {
            sb.append(", _ackId=").append(this._ackId);
        }
        if (this._time != null) {
            sb.append(", _time=").append(this._time);
        }
        if (this._fields != null) {
            for (KVPair kv : this._fields) {
                sb.append(", ").append(kv._key).append("=\"").append(kv._val).append("\"");
            }
        }
        if (this._raw != null && !this._raw.empty()) {
            sb.append(", _raw=\"").append(this._raw).append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public long getAckEventId() {
        return this._ackId;
    }

    public Channel getChannel() {
        return this._chan;
    }

    public long getChannelId() {
        return this._chan == null ? -1L : this._chan.getId();
    }

    public boolean isParsedEvent() {
        return (this._flags & 0x40) != 0;
    }

    public boolean hasDoneFlag() {
        return (this._flags & 0x200) != 0;
    }

    public boolean hasFlushFlag() {
        return (this._flags & 0x400) != 0;
    }

    public boolean hasAckId() {
        return (this._flags & 4) != 0;
    }

    public S2SString getRaw() {
        return this._raw;
    }

    public S2SString getIndex() {
        return this._index;
    }

    public boolean hasTime() {
        return this._time != null;
    }

    public Number getTime() {
        return this._time;
    }

    public Number getNonNullTime() {
        return this._nonNullTime;
    }

    public List<KVPair> getFields() {
        return this._fields;
    }

    @Override
    public void readFromS2SV4(InputStream in, StreamingS2S parent) throws IOException {
        long channelId = S2SUtil.readBase128(in);
        this._chan = parent.getChannel(channelId);
        this._flags = (int)(S2SUtil.readBase128(in) & 0xFFFFL);
        if ((this._flags & 2) > 0) {
            S2SUtil.readBase128(in);
            S2SUtil.readBase128(in);
            S2SUtil.readBase128(in);
        }
        if ((this._flags & 4) > 0) {
            this._ackId = S2SUtil.readBase128(in);
        }
        if ((this._flags & 8) > 0) {
            this._time = new Long(S2SUtil.readBase128(in));
        }
        int fields = (int)S2SUtil.readBase128(in);
        this._fields = new ArrayList(fields);
        boolean foundPath = false;
        boolean foundIndex = false;
        boolean foundSubsec = false;
        for (int i = 0; i < fields; ++i) {
            KVPair kv = this.readEventKeyValue(in, this, parent);
            if (!foundPath && kv._key.equals(FIELD_KEY_PATH)) {
                foundPath = true;
                continue;
            }
            if (!foundIndex && kv._key.equals(FIELD_INDEX)) {
                foundIndex = true;
                this._index = (S2SString)kv._val;
                continue;
            }
            if (!foundSubsec && kv._key.equals(S2SUtil.PREDEFINED_STRINGS[0])) {
                foundSubsec = true;
                StringBuilder sb = new StringBuilder(12);
                sb.append(this._time).append(".");
                long encodedSubsecs = ((S2SLong)kv._val)._value;
                while ((encodedSubsecs & 1L) == 0L) {
                    sb.append('0');
                    encodedSubsecs >>>= 1;
                }
                if (encodedSubsecs > 1L) {
                    sb.append(encodedSubsecs >>> 1);
                }
                this._time = new BigDecimal(sb.toString());
                continue;
            }
            this._fields.add(kv);
        }
        this._nonNullTime = null == this._time ? this.getCurrentTime() : this._time;
        if ((this._flags & 1) > 0) {
            this._raw = new S2SString();
            this._raw.readFromS2SV4(in, parent);
        }
    }

    private KVPair readEventKeyValue(InputStream in, Event event, StreamingS2S parent) throws IOException {
        int combinedType = (int)S2SUtil.readBase128(in);
        boolean dontIndexUnsquashed = (combinedType & 0x40) > 0;
        int valType = (combinedType &= 0xFFFFFFBF) >>> 2 & 0xF;
        int keyType = combinedType & 3;
        S2SString key = null;
        S2SValue val = null;
        switch (keyType) {
            case 1: {
                key = this._chan.getPredefinedField((int)S2SUtil.readBase128(in));
                break;
            }
            case 2: {
                key = S2SUtil.PREDEFINED_STRINGS[(int)S2SUtil.readBase128(in)];
                break;
            }
            case 0: 
            case 3: {
                key = new S2SString();
                key.readFromS2SV4(in, parent);
                break;
            }
            default: {
                throw new RuntimeException("Unknown keyType value=" + keyType);
            }
        }
        switch (valType) {
            case 1: {
                val = S2SString.newFrom(in, parent);
                break;
            }
            case 0: {
                val = S2SLong.newFrom(in, parent);
                break;
            }
            case 2: {
                val = S2SUtil.PREDEFINED_STRINGS[(int)S2SUtil.readBase128(in)];
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int off = (int)S2SUtil.readBase128(in);
                int len = (int)S2SUtil.readBase128(in);
                val = new OffsetLenValue(event, valType, off, len);
                break;
            }
            default: {
                throw new RuntimeException("Unknown valType value=" + valType);
            }
        }
        return new KVPair(key, val);
    }

    public static Event readOldS2SEvent(InputStream rawIn, StreamingS2S parent) throws IOException {
        Event e = new Event();
        int eventSize = S2SUtil.readInt(rawIn);
        byte[] buf = new byte[eventSize];
        S2SUtil.readFully(rawIn, buf);
        ByteArrayInputStream in = new ByteArrayInputStream(buf);
        int fields = S2SUtil.readInt(in);
        e._fields = new ArrayList(fields);
        for (int i = 0; i < fields; ++i) {
            int keySize = S2SUtil.readInt(in) - 1;
            S2SString key = new S2SString(keySize);
            S2SString.readFully(in, key);
            ((InputStream)in).read();
            int valSize = S2SUtil.readInt(in) - 1;
            S2SString val = new S2SString(valSize);
            S2SString.readFully(in, val);
            ((InputStream)in).read();
            e._fields.add(new KVPair(key, val));
        }
        return e;
    }

    BigDecimal getCurrentTime() {
        return new BigDecimal(System.currentTimeMillis()).divide(ONE_THOUSAND);
    }

    public static class OffsetLenValue
    implements S2SValue {
        int _offset = 0;
        int _length = 0;
        int _type = 0;
        Event _parent;

        public OffsetLenValue(Event parent, int type, int off, int len) {
            this._parent = parent;
            this._offset = off;
            this._length = len;
            this._type = type;
        }

        @Override
        public byte[] getBytes() {
            return this._parent.getRaw().getBytes();
        }

        @Override
        public int getOffset() {
            return this._offset;
        }

        @Override
        public int size() {
            return this._length;
        }

        @Override
        public boolean isNumber() {
            return false;
        }

        @Override
        public Number asNumber() {
            throw new UnsupportedOperationException("Not a number");
        }

        public String toString() {
            return "_raw.off=" + this._offset + ", len=" + this._length + ", type=" + this._type;
        }
    }

    public static class KVPair {
        public S2SString _key;
        public S2SValue _val;

        public KVPair(S2SString k, S2SValue v) {
            this._key = k;
            this._val = v;
        }
    }
}

