/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.data_delivery;

import com.splunk.collect.AbstractEventWriter;
import com.splunk.collect.AvroEventWriter;
import com.splunk.collect.CommitListener;
import com.splunk.collect.EventWriter;
import com.splunk.collect.EventWriterFactory;
import com.splunk.collect.IndexProcessor;
import com.splunk.collect.IndexS2SListener;
import com.splunk.collect.KafkaEventWriter;
import com.splunk.collect.NoOpEventWriter;
import com.splunk.collect.ParquetEventWriter;
import com.splunk.collect.PlainTextEventWriter;
import com.splunk.collect.SeqFileEventWriter;
import com.splunk.data_delivery.LicenseChecker;
import com.splunk.data_delivery.S2SStreamingRelay;
import com.splunk.io.SearchOutputStream;
import com.splunk.mr.CommandHandler;
import com.splunk.mr.SplunkMR;
import com.splunk.roll.util.OutputUtil;
import com.splunk.sdk.SplunkMiniSDK;
import com.splunk.util.JsonUtil;
import com.splunk.util.TimeUtils;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class ForwardingHandler
implements CommandHandler {
    public static final String OUTPUT_PATH = "data.delivery.output.root.path";
    public static final String PORT = "data.delivery.port";
    public static final String FORMAT = "data.delivery.format";
    public static final String COMPRESSION = "data.delivery.compression";
    public static final String COOKED_LIMIT = "data.delivery.bytes.per.file";
    public static final String INPUT_INDEXES = "data.delivery.allowed.indexes";
    public static final String COMMIT_BATCHES = "data.delivery.commit.batch.size";
    public static final String COMMIT_PAUSE = "data.delivery.commit.period";
    public static final String RENAME_ON_CLOSE = "data.delivery.rename.on.close";
    public static final String PARTITION_FORMAT = "data.delivery.partition.format";
    public static final String OUTPUT_TYPE = "data.delivery.output.type";
    public static final String KAFKA_PREFIX = "data.delivery.kafka.";
    public static final String PARQUET_BLOCK_SIZE = "data.delivery.parquet.block.size";
    public static final String PARQUET_PAGE_SIZE = "data.delivery.parquet.page.size";
    public static final String PARQUET_DICT_SIZE = "data.delivery.parquet.dict.size";
    public static final String PARQUET_ENABLE_DICT = "data.delivery.parquet.enable.dict";
    public static final String PARQUET_ENABLE_VALIDATING = "data.delivery.parquet.enable.validating";
    static final String[] REQUIRED_PROPS = new String[]{"data.delivery.port", "data.delivery.allowed.indexes"};
    static final String[] REQUIRED_HDFS_PROPS = new String[]{"data.delivery.output.root.path", "data.delivery.format"};
    private static final Logger gLogger = Logger.getLogger(ForwardingHandler.class);
    private S2SStreamingRelay relay;
    static final long GIGABYTE = 0x40000000L;
    long cookedMaxBytes = 0x100000000L;
    int port;
    String format;
    String codec;
    String[] inputIndexes;
    Path baseDir;
    int commitBatchSize;
    int commitPeriod;
    boolean renameOnClose;
    String partionFormat;
    String outputType;
    Properties kafkaProperties;
    Configuration conf;
    SplunkMiniSDK sdkInstance;
    JsonNode providerInfo;

    @Override
    public void execute(Configuration conf, Map<String, Object> args, SearchOutputStream out) throws Exception {
        this.conf = conf;
        this.conf.setBoolean("fs.hdfs.impl.disable.cache", true);
        JsonNode jsonTree = JsonUtil.valueToTree(new ObjectMapper(), args);
        JsonNode erpConf = jsonTree.path("conf");
        this.providerInfo = erpConf.path("provider");
        if (this.providerInfo.size() == 0) {
            gLogger.warn((Object)"No provider given. Cannot start listening");
            return;
        }
        JsonNode jsonNode = this.providerInfo.path("name");
        if (jsonNode.isMissingNode()) {
            throw new IllegalArgumentException("Could not find \"name\" in the provided config arguments.");
        }
        SplunkMR.changeSearchHeadLoggerforDataDelivery(this.providerInfo.path("name").getTextValue());
        gLogger.info((Object)"Initiating Data Delivery");
        if (!new LicenseChecker(conf).isLicenseValid()) {
            throw new Exception("Invalid License for Data Delivery");
        }
        new Thread((Runnable)new SplunkTether(), "Splunkd tether").start();
        this.parseConfigurations(this.providerInfo, conf);
        this.relay = new S2SStreamingRelay(this.port, this);
        this.relay.run();
    }

    public SplunkMiniSDK getSDK() {
        if (null == this.sdkInstance) {
            this.sdkInstance = SplunkMiniSDK.createForForwarding(this.conf);
        }
        return this.sdkInstance;
    }

    void parseConfigurations(JsonNode destinationProvider, Configuration conf) throws IOException {
        this.verifyVixHasRequiredFields("provider", destinationProvider, REQUIRED_PROPS);
        this.port = JsonUtil.getInt(destinationProvider, PORT);
        this.inputIndexes = JsonUtil.getCommaSeparatedStringList(destinationProvider, INPUT_INDEXES);
        String name = destinationProvider.path("name").getTextValue();
        gLogger.info((Object)("Provider " + name + " will listen on port " + this.port + " to deliver data from these indexes: " + Arrays.asList(this.inputIndexes)));
        this.outputType = JsonUtil.getString(destinationProvider, OUTPUT_TYPE, "hdfs");
        if (this.outputType.equals("hdfs")) {
            this.verifyVixHasRequiredFields("provider", destinationProvider, REQUIRED_HDFS_PROPS);
            this.format = destinationProvider.path(FORMAT).getTextValue();
            this.cookedMaxBytes = JsonUtil.getPositiveLong(destinationProvider, COOKED_LIMIT, this.cookedMaxBytes);
            this.codec = destinationProvider.path(COMPRESSION).getTextValue();
            if ("none".equals(this.codec) || "uncompressed".equals(this.codec)) {
                this.codec = null;
            }
            FileSystem fs = FileSystem.get((Configuration)conf);
            this.baseDir = JsonUtil.getPath(destinationProvider, OUTPUT_PATH, fs);
            gLogger.info((Object)("Provider " + name + " will output in format=" + this.format + (null == this.codec ? " without compression" : " with compression codec=" + this.codec) + " to base path=" + this.baseDir));
        } else if (this.outputType.equals("kafka")) {
            this.cookedMaxBytes = JsonUtil.getPositiveLong(destinationProvider, COOKED_LIMIT, Long.MAX_VALUE);
            this.kafkaProperties = this.getKafkaProperties(destinationProvider, conf);
        }
        this.partionFormat = JsonUtil.getString(destinationProvider, PARTITION_FORMAT, null);
        this.renameOnClose = JsonUtil.getBoolean(destinationProvider, RENAME_ON_CLOSE, true);
        this.commitBatchSize = JsonUtil.getNonnegativeInt(destinationProvider, COMMIT_BATCHES, 0);
        this.commitPeriod = JsonUtil.getNonnegativeInt(destinationProvider, COMMIT_PAUSE, 0);
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Partition format: " + this.partionFormat));
            gLogger.debug((Object)("Write initially to temp file? " + this.renameOnClose));
            gLogger.debug((Object)("Maximum pre-compression bytes per file: " + this.cookedMaxBytes));
            gLogger.debug((Object)("Commit batch size: " + this.commitBatchSize + ", commit period: " + this.commitPeriod));
        }
        Iterator fieldIter = destinationProvider.getFieldNames();
        while (fieldIter.hasNext()) {
            String fieldName = (String)fieldIter.next();
            if (!fieldName.startsWith("data.delivery")) continue;
            String val = destinationProvider.get(fieldName).getTextValue();
            if (null == val) {
                val = "";
            }
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Adding to pair to configuration with key=" + fieldName + ", value=" + val));
            }
            conf.set(fieldName, val);
        }
    }

    IndexS2SListener createListener(boolean trackIds, CommitListener commitListener) {
        IndexS2SListener listener = new IndexS2SListener();
        for (String idx : this.inputIndexes) {
            IndexProcessor processor = new IndexProcessor(trackIds, idx, this.conf, this.baseDir, this.getEventWriterFactory(this.format), this.partionFormat, this.outputType);
            if (null != commitListener) {
                processor.addCommitListener(commitListener);
            }
            this.configureProcessor(processor, commitListener);
            listener.addIndex(processor);
        }
        if (trackIds) {
            IndexProcessor noOpProc = new IndexProcessor(trackIds, "no-op", this.conf, this.baseDir, this.getNoOpEventWriterFactory(), this.partionFormat, this.outputType);
            this.configureProcessor(noOpProc, commitListener);
            listener.addCatchAllProcessor(noOpProc);
        }
        return listener;
    }

    private void configureProcessor(IndexProcessor ip, CommitListener commitListener) {
        ip.setAutoCommitBehavior(this.commitBatchSize, this.commitPeriod);
        ip.setParsedMaxBytes(this.cookedMaxBytes);
        if (null != commitListener) {
            ip.addCommitListener(commitListener);
        }
    }

    private Properties getKafkaProperties(JsonNode node, Configuration conf) {
        Properties kafkaProperties = new Properties();
        Iterator itr = node.getFieldNames();
        while (itr.hasNext()) {
            String property = (String)itr.next();
            if (!property.startsWith(KAFKA_PREFIX)) continue;
            String kafkaProperty = property.substring(KAFKA_PREFIX.length());
            kafkaProperties.setProperty(kafkaProperty, node.path(property).getTextValue());
        }
        return kafkaProperties;
    }

    private String getVixName(JsonNode vix) {
        return vix.path("name").getTextValue();
    }

    private void verifyVixHasRequiredFields(String category, JsonNode vix, String[] requiredConfFields) {
        ArrayList<String> verificationMessages = new ArrayList<String>();
        for (String requiredField : requiredConfFields) {
            if (JsonUtil.has(vix, requiredField)) continue;
            verificationMessages.add(category + "=" + this.getVixName(vix) + " did not have required conf field=" + requiredField + ". ");
        }
        if (!verificationMessages.isEmpty()) {
            throw new RuntimeException(((Object)verificationMessages).toString());
        }
    }

    private EventWriterFactory getNoOpEventWriterFactory() {
        return new EventWriterFactory(){

            @Override
            public EventWriter getHadoopEventWriter(Configuration conf, boolean raw, Path dir, String baseName) {
                return new NoOpEventWriter(true);
            }

            @Override
            public EventWriter getKafkaEventWriter(Configuration conf, String key) {
                return new NoOpEventWriter(true);
            }
        };
    }

    private EventWriterFactory getEventWriterFactory(final String format) {
        return new EventWriterFactory(){

            @Override
            public EventWriter getHadoopEventWriter(Configuration conf, boolean raw, Path dir, String baseName) {
                AbstractEventWriter result;
                block7: {
                    gLogger.info((Object)("New event writer requested. format = " + format + ", raw? " + raw + ", dir = " + dir + ", baseName = " + baseName));
                    result = null;
                    try {
                        if (raw) {
                            return new SeqFileEventWriter(conf, dir, ForwardingHandler.this.codec, true);
                        }
                        if ("parquet".equals(format)) {
                            result = new ParquetEventWriter(conf, dir, ForwardingHandler.this.codec, ForwardingHandler.this.renameOnClose);
                            break block7;
                        }
                        if ("seq".equals(format) || format == null) {
                            result = new SeqFileEventWriter(conf, dir, ForwardingHandler.this.codec, ForwardingHandler.this.renameOnClose);
                            break block7;
                        }
                        if ("avro".equals(format)) {
                            result = new AvroEventWriter(conf, dir, ForwardingHandler.this.codec, ForwardingHandler.this.renameOnClose);
                            break block7;
                        }
                        if ("plain".equals(format)) {
                            result = new PlainTextEventWriter(conf, dir, ForwardingHandler.this.codec, ForwardingHandler.this.renameOnClose);
                            break block7;
                        }
                        gLogger.info((Object)"Throwing exception");
                        throw new IllegalArgumentException("Unknown event format=" + format);
                    }
                    catch (Exception e) {
                        gLogger.info((Object)"Error while creating HDFS EventWriter", (Throwable)e);
                    }
                }
                gLogger.info((Object)("Returning result: " + result));
                return result;
            }

            @Override
            public EventWriter getKafkaEventWriter(Configuration conf, String key) {
                KafkaEventWriter result = null;
                try {
                    result = new KafkaEventWriter(conf, ForwardingHandler.this.kafkaProperties, key);
                }
                catch (Exception e) {
                    gLogger.info((Object)"Error while creating Kafka EventWriter", (Throwable)e);
                }
                gLogger.info((Object)("Returning result: " + result));
                return result;
            }
        };
    }

    class SplunkTether
    implements Runnable {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(FileDescriptor.out));
        private ObjectMapper jsonMapper = new ObjectMapper();

        SplunkTether() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    SplunkTether splunkTether = this;
                    synchronized (splunkTether) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                HashMap<String, String> m = new HashMap<String, String>();
                if (ForwardingHandler.this.relay == null) {
                    m.put("Connections made", "0");
                } else {
                    m.put("port", Integer.toString(ForwardingHandler.this.relay.getPort()));
                    m.put("Connections made", Long.toString(ForwardingHandler.this.relay.getConnectionsHandled()));
                }
                try {
                    this.writeAsEvent("Data forwarding process: ", m);
                }
                catch (IOException ex) {
                    gLogger.info((Object)"Parent process is unreachable. Shutting down.");
                    ForwardingHandler.this.relay.terminate();
                    return;
                }
            }
        }

        void writeAsEvent(String prefix, Map<String, String> m) throws IOException {
            String raw = OutputUtil.kvSeparated(m);
            m.put("_raw", raw);
            m.put("_time", TimeUtils.getSplunkTime());
            m.put("prefix", prefix);
            this.out.write(this.jsonMapper.writeValueAsBytes(m));
            this.out.write(10);
            this.out.flush();
        }
    }
}

