/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.log4j.Logger;

public class EventWriterUtil {
    private static Logger gLogger = Logger.getLogger(EventWriterUtil.class);

    public static CompressionCodec getCompressionCodec(String codecName, CompressionCodecFactory factory) {
        if (codecName != null) {
            String name = EventWriterUtil.getExtension(codecName);
            Path dummyFile = new Path("foo" + name);
            return factory.getCodec(dummyFile);
        }
        return null;
    }

    public static String getExtension(String codecName) {
        if (codecName == null) {
            return null;
        }
        int idx = codecName.indexOf(95);
        String name = codecName.substring(idx + 1);
        if ("lzo".equals(name)) {
            name = "lzo_deflate";
        } else if ("gzip".equals(name)) {
            name = "gz";
        } else if ("bzip".equals(name) || "bzip2".equals(name)) {
            name = "bz2";
        } else if ("snappy".equals(name)) {
            name = "snappy";
        }
        return '.' + name;
    }

    public static void postCloseCleanup(Configuration conf, Path location, long rawBytesWritten, long numEventsWritten, boolean renameOnClose) throws IOException {
        if (rawBytesWritten == 0L) {
            if (location != null) {
                gLogger.info((Object)("Removing empty file, path=" + location));
                location.getFileSystem(conf).delete(location, false);
            }
        } else {
            Path closedPath = location;
            if (renameOnClose) {
                String name = location.getName();
                if (!name.endsWith(".tmp")) {
                    gLogger.warn((Object)"Inconsistent state. Thought we were writing to a temporary file, but had wrong extension.");
                } else {
                    name = name.substring(0, name.length() - ".tmp".length());
                    closedPath = new Path(location.getParent(), name);
                    FileSystem fs = FileSystem.get((Configuration)conf);
                    fs.rename(location, closedPath);
                }
            }
            gLogger.info((Object)("Closed! EventCount=" + numEventsWritten + ", p=" + closedPath));
        }
    }
}

