/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.CommitListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class AcknowledgementCommitListener
implements CommitListener {
    private static final Logger gLogger = Logger.getLogger(AcknowledgementCommitListener.class);
    OutputStream out;
    byte[] cowTail;

    public AcknowledgementCommitListener(OutputStream out) {
        this.out = out;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(new byte[]{0, 0, 0, 0});
            this.writeString("_raw", baos);
            this.cowTail = baos.toByteArray();
        }
        catch (IOException ex) {
            gLogger.error((Object)ex);
        }
    }

    @Override
    public void commitCompleted(long[] commitedIds) throws IOException {
        Arrays.sort(commitedIds);
        int startIdx = 0;
        int len = commitedIds.length;
        for (int i = 1; i < len; ++i) {
            if (commitedIds[i] - commitedIds[i - 1] == 1L) continue;
            this.writeRange(commitedIds[startIdx], commitedIds[i - 1]);
            startIdx = i;
        }
        long start = commitedIds[startIdx];
        long end = commitedIds[len - 1];
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Sending ACK message for event range " + start + " - " + end));
        }
        this.writeRange(start, end);
        try {
            this.out.flush();
        }
        catch (SocketException ex) {
            gLogger.warn((Object)"Unable to send ACK message, possibly due to splunkd shutting down.", (Throwable)ex);
        }
    }

    private void writeRange(long start, long end) throws IOException {
        ByteArrayOutputStream cowPipelineData = new ByteArrayOutputStream();
        int numberOfKeyValuePairs = 1;
        this.writeInt(numberOfKeyValuePairs, cowPipelineData);
        this.writeString("__s2s_eventId", cowPipelineData);
        StringBuilder committedEventIds = new StringBuilder();
        committedEventIds.append(Long.toString(start));
        committedEventIds.append("-");
        committedEventIds.append(Long.toString(end));
        this.writeString(committedEventIds.toString(), cowPipelineData);
        this.writeCowPipelineData(cowPipelineData, this.out);
    }

    void writeInt(int n, OutputStream baos) throws IOException {
        for (int i = 3; i >= 0; --i) {
            int b = n >> 8 * i & 0xFF;
            baos.write(b);
        }
    }

    void writeString(String text, ByteArrayOutputStream baos) throws IOException {
        byte[] textAsBytes = text.getBytes();
        this.writeInt(textAsBytes.length + 1, baos);
        baos.write(textAsBytes);
        baos.write(0);
    }

    void writeCowPipelineData(ByteArrayOutputStream kvPairs, OutputStream out) throws IOException {
        kvPairs.write(this.cowTail);
        byte[] data = kvPairs.toByteArray();
        this.writeInt(data.length, out);
        out.write(data);
    }
}

