/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.datasource.hive.TableSchema;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.HiveSplitGenerator;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.LineRecordReader;
import com.splunk.util.ReflectionUtil;
import com.splunk.util.SerDeUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.RegexSerDe;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.LineReader;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class HiveRecordReader
extends BaseSplunkRecordReader {
    protected static Logger gLogger = Logger.getLogger(HiveRecordReader.class);
    protected Text key = new Text();
    protected Text value = new Text();
    protected Object rrKey;
    protected Object rrValue;
    protected SerDe serDe;
    protected org.apache.hadoop.mapred.RecordReader mapredRR;
    protected RecordReader mapreduceRR;
    protected ObjectMapper mapper = new ObjectMapper();
    protected StringBuilder record = new StringBuilder();
    protected Map<Integer, Map> readColumnIds;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream(1024){

        @Override
        public synchronized byte[] toByteArray() {
            return this.buf;
        }
    };

    @Override
    public String getOutputDataFormat() {
        return "json";
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        this.buf.reset();
        this.serializeCurrentValueTo(this.buf);
        Text v = new Text();
        v.set(this.buf.toByteArray(), 0, this.buf.size());
        return v;
    }

    @Override
    public void serializeCurrentValueTo(OutputStream out) throws IOException, InterruptedException {
        StructObjectInspector oi;
        Object row;
        if (this.mapreduceRR != null) {
            this.rrValue = this.mapreduceRR.getCurrentValue();
        }
        Writable curValue = (Writable)this.rrValue;
        try {
            row = this.serDe.deserialize(curValue);
            oi = (StructObjectInspector)this.serDe.getObjectInspector();
        }
        catch (SerDeException e) {
            throw new IOException("Failed to deserialize value using serDe, curValue=" + curValue + ":" + e.getMessage(), e);
        }
        JsonGenerator jg = this.mapper.getJsonFactory().createJsonGenerator(out, JsonEncoding.UTF8);
        SerDeUtil.buildJSONString(jg, oi, row, this.readColumnIds);
        jg.flush();
    }

    private void convertStringKeyToInt(Map<String, Map> src, Map<Integer, Map> dest) {
        if (src == null || src.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map> e : src.entrySet()) {
            Map map = new HashMap<Integer, Map>();
            this.convertStringKeyToInt(e.getValue(), map);
            if (map.isEmpty()) {
                map = e.getValue();
            }
            if (dest == null) continue;
            dest.put(Integer.parseInt(e.getKey()), map);
        }
    }

    @Override
    public void vixInitialize(VixInputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TableSchema ts;
        VixInputSplit realSplit;
        block25: {
            realSplit = split;
            String schema = split.getExtra("splunk.hive.tableschema");
            ts = (TableSchema)this.mapper.readValue(schema, TableSchema.class);
            try {
                if (ts.readColIds != null) {
                    this.readColumnIds = new HashMap<Integer, Map>();
                    this.convertStringKeyToInt(ts.readColIds, this.readColumnIds);
                    ColumnProjectionUtils.setReadColumnIDs((Configuration)this._conf, this.readColumnIds.isEmpty() ? Arrays.asList(Integer.MAX_VALUE) : new ArrayList<Integer>(this.readColumnIds.keySet()));
                } else {
                    ColumnProjectionUtils.setFullyReadColumns((Configuration)this._conf);
                }
            }
            catch (Exception e) {
                if (gLogger.isDebugEnabled()) {
                    gLogger.error((Object)"Failed to normalize the list of read column ids, return all columns.", (Throwable)e);
                } else {
                    gLogger.error((Object)("Failed to normalize the list of read column ids, return all columns." + e.getMessage()));
                }
                this.readColumnIds = null;
                ColumnProjectionUtils.setFullyReadColumns((Configuration)this._conf);
            }
            if (this.serDe == null) {
                try {
                    this.serDe = (SerDe)ReflectionUtil.newInstance(ts.serdeInfo.serializationLib, new Object[0]);
                }
                catch (RuntimeException e) {
                    if (!(e.getCause() instanceof ClassNotFoundException) || !String.valueOf(e.getMessage()).contains("org.apache.hadoop.hive.contrib.serde2.RegexSerDe") || !"org.apache.hadoop.hive.contrib.serde2.RegexSerDe".equals(ts.serdeInfo.serializationLib)) break block25;
                    gLogger.warn((Object)"Failed to instantiate the serde class RegexSerDe specified by user, will try the one from another package", (Throwable)e);
                    this.serDe = (SerDe)ReflectionUtil.newInstance(RegexSerDe.class.getName(), new Object[0]);
                }
            }
        }
        try {
            gLogger.debug((Object)("ts.serdeInfo.parameters=" + ts.serdeInfo.parameters));
            this.serDe.initialize(this._conf, ts.serdeInfo.parameters);
        }
        catch (Exception e) {
            gLogger.error((Object)"Failed to initialize hive serDe", (Throwable)e);
            throw new IllegalArgumentException("Failed to initialize hive serDe, serDeClass=" + ts.serdeInfo.serializationLib + ":" + e.getMessage(), e);
        }
        if (ts.fileFormat == HiveSplitGenerator.FileFormat.orc && ts.filterExpr != null) {
            this._conf.set("hive.io.filter.expr.serialized", ts.filterExpr);
            String readColNames = ts.tableColNames;
            ArrayList readColIds = ColumnProjectionUtils.getReadColumnIDs((Configuration)this._conf);
            if (!(readColIds == null || readColIds.isEmpty() || readColIds.size() == 1 && (Integer)readColIds.get(0) == Integer.MAX_VALUE)) {
                String[] names = ts.tableColNames.split(",");
                StringBuilder sb = new StringBuilder();
                Iterator iterator = readColIds.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    sb.append(names[i]).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                readColNames = sb.toString();
            }
            this._conf.set("hive.io.file.readcolumn.names", readColNames);
        }
        if (ts.fileFormat == HiveSplitGenerator.FileFormat.textfile && !this.hadoopSupportCustomDelimiter() && ts.serdeInfo.parameters.containsKey("line.delim")) {
            this.mapreduceRR = new LineRecordReader(ts.serdeInfo.parameters.getProperty("line.delim").getBytes(Charset.forName("UTF-8")));
        } else if (this.mapredRR == null && this.mapreduceRR == null) {
            org.apache.hadoop.mapred.InputFormat in;
            Object o = ReflectionUtil.newInstance(ts.inputFormat, new Object[0]);
            FileSplit fileSplit = new FileSplit(split.getPath(), split.getStart(), split.getLength(), split.getLocations());
            if (o instanceof org.apache.hadoop.mapred.InputFormat) {
                in = (org.apache.hadoop.mapred.InputFormat)o;
                this.mapredRR = in.getRecordReader((InputSplit)fileSplit, new JobConf(this._conf), Reporter.NULL);
            } else if (o instanceof InputFormat) {
                in = (InputFormat)o;
                this.mapreduceRR = in.createRecordReader((org.apache.hadoop.mapreduce.InputSplit)fileSplit, context);
            } else {
                throw new IllegalArgumentException("Invalid Hive recordreader property fileformat.inputformat: not a valid hadoop InputFormat");
            }
        }
        if (this.mapredRR != null) {
            this.rrKey = this.mapredRR.createKey();
            this.rrValue = this.mapredRR.createValue();
        } else if (this.mapreduceRR != null) {
            this.mapreduceRR.initialize((org.apache.hadoop.mapreduce.InputSplit)realSplit, context);
        } else {
            throw new RuntimeException("Failed to initialize HiveRecordReader: one and only one flavor of RecordReader must be initialized.");
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.mapredRR != null) {
            return this.mapredRR.next(this.rrKey, this.rrValue);
        }
        return this.mapreduceRR.nextKeyValue();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.mapredRR != null) {
                this.mapredRR.close();
            } else if (this.mapreduceRR != null) {
                this.mapreduceRR.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        if (this.mapredRR != null) {
            return this.mapredRR.getProgress();
        }
        return this.mapreduceRR.getProgress();
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        if (this.mapreduceRR != null) {
            this.rrKey = this.mapreduceRR.getCurrentKey();
        }
        this.key.set(String.valueOf(this.rrKey));
        return this.key;
    }

    public static String getNameStatically() {
        return "hive";
    }

    @Override
    public String getName() {
        return HiveRecordReader.getNameStatically();
    }

    @Override
    public Pattern getFilePattern() {
        return SplunkMR.ACCEPT_ALL_PATTERN;
    }

    private boolean hadoopSupportCustomDelimiter() {
        for (Method m : LineReader.class.getDeclaredMethods()) {
            if (!"readCustomLine".equals(m.getName())) continue;
            return true;
        }
        return false;
    }
}

