/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal.hadoop;

import com.splunk.journal.EventData;
import com.splunk.journal.RawdataJournalReader;
import com.splunk.journal.SimpleCsvWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class KeyValueFormatter {
    private static Map<String, FormatSupportedField> nameToFormatSupportedField = new HashMap<String, FormatSupportedField>();
    private EventData event;
    private Map<String, Object> fields;
    private final FieldReader[] keyList;
    private final FieldReader[] valueList;
    private final ByteArrayOutputStream textBuffer = new ByteArrayOutputStream();
    private final SimpleCsvWriter csvWriter = new SimpleCsvWriter(new OutputStreamWriter(this.textBuffer));

    public static String[] getBuiltinFieldNames() {
        FormatSupportedField[] fields = FormatSupportedField.values();
        String[] names = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            names[i] = fields[i].name();
        }
        return names;
    }

    public KeyValueFormatter(String[] keyFieldNames, String[] valueFieldNames, Character escapeChar, Character separatorChar) {
        this.keyList = this.convertStringToFields(keyFieldNames);
        this.valueList = this.convertStringToFields(valueFieldNames);
        if (null != escapeChar) {
            this.csvWriter.setEscapeChar(escapeChar.charValue());
        }
        if (null != separatorChar) {
            this.csvWriter.setSeparatorChar(separatorChar.charValue());
        }
    }

    public void setEventData(EventData eventData) {
        this.event = eventData;
        this.fields = null;
    }

    public byte[] readKey() {
        return this.readFields(this.keyList);
    }

    public byte[] readValue() {
        return this.readFields(this.valueList);
    }

    private byte[] readFields(FieldReader[] fieldList) {
        this.textBuffer.reset();
        try {
            for (int i = 0; i < fieldList.length; ++i) {
                FieldReader fieldReader = fieldList[i];
                String val = fieldReader.getValueFrom(this.event);
                if (i == 0) {
                    this.csvWriter.writeFirstFieldInRow(val);
                    continue;
                }
                this.csvWriter.writeSubequentField(val);
            }
            this.csvWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.textBuffer.toByteArray();
    }

    private FieldReader[] convertStringToFields(String[] fieldNames) {
        FieldReader[] fieldReaders = new FieldReader[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            FieldReader reader = nameToFormatSupportedField.get(name.trim());
            if (null == reader) {
                reader = new StringReferencedField(name);
            }
            fieldReaders[i] = reader;
        }
        return fieldReaders;
    }

    static {
        for (FormatSupportedField fsf : FormatSupportedField.values()) {
            nameToFormatSupportedField.put(fsf.name(), fsf);
        }
    }

    private static enum FormatSupportedField implements FieldReader
    {
        _time{

            @Override
            public String getValueFrom(EventData eventData) {
                return Long.toString(eventData.getEventTime());
            }
        }
        ,
        time_float{

            @Override
            public String getValueFrom(EventData eventData) {
                return eventData.getTimeString();
            }
        }
        ,
        _indextime{

            @Override
            public String getValueFrom(EventData eventData) {
                return Long.toString(eventData.getIndexTime());
            }
        }
        ,
        sourcetype{

            @Override
            public String getValueFrom(EventData eventData) {
                return eventData.getSourcetype();
            }
        }
        ,
        host{

            @Override
            public String getValueFrom(EventData eventData) {
                return eventData.getHost();
            }
        }
        ,
        source{

            @Override
            public String getValueFrom(EventData eventData) {
                return eventData.getSource();
            }
        }
        ,
        _raw{

            @Override
            public String getValueFrom(EventData eventData) {
                return new String(eventData.getRawContents(), RawdataJournalReader.UTF_8);
            }
        };


        @Override
        public abstract String getValueFrom(EventData var1);
    }

    private class StringReferencedField
    implements FieldReader {
        String fieldName;

        public StringReferencedField(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String getValueFrom(EventData eventData) {
            Object val;
            if (null == KeyValueFormatter.this.fields) {
                KeyValueFormatter.this.fields = KeyValueFormatter.this.event.getFields();
            }
            return null == (val = KeyValueFormatter.this.fields.get(this.fieldName)) ? "" : val.toString();
        }
    }

    private static interface FieldReader {
        public String getValueFrom(EventData var1);
    }
}

