/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.AbstractEventWriter;
import com.splunk.collect.EventWriterUtil;
import com.splunk.s2s.Channel;
import com.splunk.s2s.Event;
import com.splunk.s2s.S2SString;
import com.splunk.s2s.S2SValue;
import com.splunk.s2s.TCPSignature;
import com.splunk.util.TextUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class SeqFileEventWriter
extends AbstractEventWriter {
    private static Logger gLogger = Logger.getLogger(SeqFileEventWriter.class);
    private static final int VALUE_TYPE_EVENT = 1;
    private static final int VALUE_TYPE_RAW = 2;
    private static final int VALUE_TYPE_BLOOM = 3;
    private static final int VALUE_TYPE_INDEX = 4;
    ObjectMapper _mapper = new ObjectMapper();
    Configuration _conf = null;
    FSDataOutputStream _outFOS = null;
    SequenceFile.Writer _out = null;
    boolean _closed = false;
    boolean _renameOnClose = false;
    Path _p = null;
    String _codecName = null;
    CompressionCodecFactory _codecFactory = null;
    String _fileExt = ".seq";

    public SeqFileEventWriter(Configuration conf, Path baseDir, String codec, boolean renameOnClose) {
        super(false);
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("SeqFileEventWriter constructed, writing to " + baseDir));
        }
        this._conf = conf;
        this._p = baseDir;
        this._codecName = codec;
        this._codecFactory = new CompressionCodecFactory(this._conf);
        this._renameOnClose = renameOnClose;
    }

    @Override
    public String getName() {
        return this._p.toString();
    }

    @Override
    public void close() throws IOException {
        if (this._outFOS == null) {
            return;
        }
        this._closed = true;
        IOUtils.closeQuietly((Closeable)this._out);
        this._outFOS.flush();
        this._outFOS.sync();
        IOUtils.closeQuietly((OutputStream)this._outFOS);
        EventWriterUtil.postCloseCleanup(this._conf, this._p, this.getRawEventBytes(), this.getEventCount(), this._renameOnClose);
        this._out = null;
        this._conf = null;
        this._outFOS = null;
    }

    @Override
    protected void commitImpl() {
        if (this._out == null) {
            return;
        }
        try {
            this._out.sync();
            this._outFOS.flush();
            this._outFOS.sync();
        }
        catch (IOException e) {
            gLogger.error((Object)("Error while committing, path=" + this._p), (Throwable)e);
        }
    }

    @Override
    protected void addEventImpl(Event e) throws IOException {
        this.init(e);
        Text valBuf = new Text();
        try {
            boolean isEndOfStream;
            S2SString raw = e.getRaw();
            boolean bl = isEndOfStream = e.hasDoneFlag() || e.hasFlushFlag();
            if (raw != null && raw.size() > 0) {
                try {
                    this.serializeEventInto(e, valBuf);
                    this._out.append((Writable)this.getEventKey(e), (Writable)valBuf);
                }
                catch (Exception ex) {
                    gLogger.error((Object)("Failed to add event: " + e), (Throwable)ex);
                }
            } else if (isEndOfStream && !e.isParsedEvent()) {
                this._out.append((Writable)this.getEventKey(e), (Writable)new Text());
            }
        }
        catch (Exception ex) {
            gLogger.error((Object)"Error while consuming events", (Throwable)ex);
        }
    }

    private SequenceFile.CompressionType getCompressionType() {
        if (this._codecName != null) {
            if (this._codecName.startsWith("block_")) {
                return SequenceFile.CompressionType.BLOCK;
            }
            if (this._codecName.startsWith("record_")) {
                return SequenceFile.CompressionType.RECORD;
            }
        }
        return SequenceFile.CompressionType.NONE;
    }

    private CompressionCodec getCompressionCodec() {
        if (this._codecName != null) {
            int idx = this._codecName.indexOf(95);
            String name = this._codecName.substring(idx + 1);
            if ("lzo".equals(name)) {
                name = "lzo_deflate";
            } else if ("gzip".equals(name)) {
                name = "gz";
            } else if ("bzip".equals(name) || "bzip2".equals(name)) {
                name = "bz2";
            } else if ("snappy".equals(name)) {
                name = "snappy";
            }
            Path dummyFile = new Path("foo." + name);
            CompressionCodec codec = this._codecFactory.getCodec(dummyFile);
            if (null != codec) {
                this._fileExt = '.' + name + this._fileExt;
                return codec;
            }
        }
        return null;
    }

    private void init(Event e) throws IOException {
        if (this._out != null) {
            return;
        }
        if (this._closed) {
            throw new IllegalStateException("Cannot init after close()");
        }
        CompressionCodec codec = this.getCompressionCodec();
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Using codec: " + codec));
        }
        StringBuilder name = new StringBuilder();
        name.append(e.isParsedEvent() ? "hunk_pv1_" : "hunk_rv1_");
        name.append(System.currentTimeMillis());
        name.append(this._fileExt);
        if (this._renameOnClose) {
            name.append(".tmp");
        }
        this._p = new Path(this._p, name.toString());
        this._outFOS = this._p.getFileSystem(this._conf).create(this._p);
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Opening stream to " + this._p));
        }
        SequenceFile.CompressionType type = SequenceFile.CompressionType.NONE;
        if (codec != null && (type = this.getCompressionType()) == SequenceFile.CompressionType.NONE) {
            type = SequenceFile.CompressionType.BLOCK;
        }
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Using codec: " + codec + ", compression type: " + type));
        }
        this._out = SequenceFile.createWriter((Configuration)this._conf, (FSDataOutputStream)this._outFOS, Text.class, Text.class, (SequenceFile.CompressionType)type, (CompressionCodec)codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Text getEventKey(Event e) throws IOException {
        Channel c = e.getChannel();
        boolean isDone = e.hasDoneFlag() || e.hasFlushFlag();
        boolean isParsed = e.isParsedEvent();
        Baos baos = new Baos();
        JsonGenerator jg = null;
        Text result = new Text();
        try {
            jg = this._mapper.getJsonFactory().createJsonGenerator((OutputStream)baos);
            jg.writeStartObject();
            if (e.hasTime()) {
                jg.writeFieldName("_time");
                jg.writeRawValue(e.getTime().toString());
            }
            jg.writeNumberField("type", isParsed ? 1 : 2);
            if (!isParsed) {
                jg.writeNumberField("done", isDone ? 1 : 0);
            }
            jg.writeStringField("source", c.getSource());
            jg.writeStringField("sourcetype", c.getSourcetype());
            jg.writeStringField("host", c.getHost());
            jg.writeStringField("extra", c.getExtra());
            TCPSignature fwdInfo = c.getFwdSignature();
            if (fwdInfo != null) {
                jg.writeStringField("fwd_host", fwdInfo.getHostname() + ":" + fwdInfo.getPort());
            }
            jg.writeEndObject();
            jg.flush();
            baos.toText(result);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(jg);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)jg);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeEventInto(Event e, Text result) throws IOException {
        if (e.isParsedEvent()) {
            Baos baos = new Baos();
            JsonGenerator jg = null;
            try {
                jg = this._mapper.getJsonFactory().createJsonGenerator((OutputStream)baos);
                jg.writeStartObject();
                if (e.hasTime()) {
                    jg.writeFieldName("_time");
                    jg.writeRawValue(e.getTime().toString());
                }
                jg.writeFieldName("_raw");
                jg.writeUTF8String(e.getRaw().getBytes(), 0, e.getRaw().size());
                jg.writeFieldName("source");
                jg.writeString(e.getChannel().getSource());
                jg.writeFieldName("sourcetype");
                jg.writeString(e.getChannel().getSourcetype());
                jg.writeFieldName("host");
                jg.writeString(e.getChannel().getHost());
                for (Event.KVPair kv : e.getFields()) {
                    String k = kv._key.toString();
                    jg.writeFieldName(k);
                    S2SValue v = kv._val;
                    if (v.isNumber()) {
                        Number n = v.asNumber();
                        jg.writeNumber(n.longValue());
                        continue;
                    }
                    jg.writeUTF8String(v.getBytes(), v.getOffset(), v.size());
                }
                jg.writeEndObject();
                jg.flush();
                baos.toText(result);
            }
            finally {
                jg.close();
            }
        } else {
            TextUtil.setTextInternals(result, e.getRaw().getBytes(), e.getRaw().size());
        }
    }

    private static class Baos
    extends ByteArrayOutputStream {
        private Baos() {
        }

        public void toText(Text t) {
            TextUtil.setTextInternals(t, this.buf, this.count);
        }
    }
}

