/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.matchers.TermSetUtils;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchNotNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.HashSet;
import java.util.Set;

public class ReferencedIndexVisitor
extends NodeVisitor<Set<String>> {
    @Override
    public Set<String> visit(Node node) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> visit(SearchOrNode node) {
        Set<String> merged = new HashSet<String>();
        for (int i = 0; i < node.getArguments().size(); ++i) {
            merged = TermSetUtils.union(merged, node.getArguments().get(i).accept(this));
        }
        return merged;
    }

    @Override
    public Set<String> visit(SearchAndNode node) {
        Set<String> merged = new HashSet<String>();
        for (int i = 0; i < node.getArguments().size(); ++i) {
            merged = TermSetUtils.union(merged, node.getArguments().get(i).accept(this));
        }
        return merged;
    }

    @Override
    public Set<String> visit(SearchQuotableNode node) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> visit(SearchComparisonNode node) {
        HashSet<String> referenced = new HashSet<String>();
        if (node.getLhs().getFieldName().equalsIgnoreCase("index")) {
            switch (node.getOperator()) {
                case EQUAL: 
                case EQUAL_EQUAL: 
                case NOT_EQUAL: {
                    StringNode rhs = (StringNode)node.getRhs();
                    if (rhs == null) {
                        throw new IllegalStateException("Encountered index=<value> expression, but <value> was not a StringNode.");
                    }
                    referenced.add(rhs.getValue());
                    break;
                }
                default: {
                    return referenced;
                }
            }
        }
        return referenced;
    }

    @Override
    public Set<String> visit(AndNode node) {
        Set<String> merged = new HashSet<String>();
        for (int i = 0; i < node.getArguments().size(); ++i) {
            merged = TermSetUtils.union(merged, node.getArguments().get(i).accept(this));
        }
        return merged;
    }

    @Override
    public Set<String> visit(OrNode node) {
        Set<String> merged = new HashSet<String>();
        for (int i = 0; i < node.getArguments().size(); ++i) {
            merged = TermSetUtils.union(merged, node.getArguments().get(i).accept(this));
        }
        return merged;
    }

    @Override
    public Set<String> visit(NotNode node) {
        return node.getArguments().get(0).accept(this);
    }

    @Override
    public Set<String> visit(SearchNotNode node) {
        return node.getArguments().get(0).accept(this);
    }

    @Override
    public Set<String> visit(ComparisonNode node) {
        HashSet<String> referenced = new HashSet<String>();
        if (node.getLhs() instanceof FieldNode && ((FieldNode)node.getLhs()).getFieldName().equals("index")) {
            switch (node.getOperator()) {
                case EQUAL: 
                case EQUAL_EQUAL: 
                case NOT_EQUAL: {
                    StringNode rhs = (StringNode)node.getRhs();
                    if (rhs == null) {
                        throw new IllegalStateException("Encountered index=<value> expression, but <value> was not a StringNode.");
                    }
                    referenced.add(rhs.getValue());
                    break;
                }
                default: {
                    return referenced;
                }
            }
        }
        return referenced;
    }
}

