/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.Modules;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.PredicateType;
import com.splunk.commons.ast.nodes.commands.DatamodelCommand;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.InputlookupCommand;
import com.splunk.commons.ast.nodes.commands.LookupCommand;
import com.splunk.commons.ast.nodes.commands.MStatsCommand;
import com.splunk.commons.ast.nodes.commands.McatalogCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.TStatsCommand;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.visitors.CommandRebuilder;
import com.splunk.commons.visitors.IndexQualifierVisitor;

public class DatasetsQualifierVisitor
extends CommandRebuilder {
    private final IDatasetResolver resolver;

    public DatasetsQualifierVisitor(IDatasetResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public CommandNode visit(Node node) {
        return null;
    }

    @Override
    public CommandNode visit(DatamodelCommand node) {
        String qualifiedName = Modules.getModuleQualifiedDataset(this.resolver, node.getDataset()).getModuleQualifiedName();
        return new DatamodelCommand(qualifiedName, node.getObjectName(), node.getMode(), node.getFieldNames(), node.getSpl());
    }

    @Override
    public CommandNode visit(FromCommand node) {
        Dataset dataset = Modules.getModuleQualifiedDataset(this.resolver, node.getDataset());
        return new FromCommand(dataset, node.getWhere(), node.getGroupBy(), node.getSelections(), node.getOrderings());
    }

    @Override
    public CommandNode visit(InputlookupCommand node) {
        String qualifiedName = Modules.getModuleQualifiedDataset(this.resolver, node.getDataset()).getModuleQualifiedName();
        if (node.isAppend()) {
            InputlookupCommand modified = (InputlookupCommand)node.setSource(node.getSource().accept(this));
            return new InputlookupCommand(node.getSource(), qualifiedName, node.getWhere(), node.getStart(), node.getMax());
        }
        return new InputlookupCommand(qualifiedName, node.getWhere(), node.getStart(), node.getStart());
    }

    @Override
    public CommandNode visit(LookupCommand node) {
        LookupCommand modified = (LookupCommand)node.setSource(node.getSource().accept(this));
        String qualifiedName = Modules.getModuleQualifiedDataset(this.resolver, modified.getDataset()).getModuleQualifiedName();
        return new LookupCommand(modified.getSource(), qualifiedName, modified.getJoinKeys(), modified.getMode(), modified.getSelections(), modified.isUpdate(), modified.isLocal(), modified.isRequired(), modified.isForceIndexed());
    }

    @Override
    public CommandNode visit(SearchCommand node) {
        IndexQualifierVisitor visitor = new IndexQualifierVisitor(this.resolver, "index");
        IPredicate predicate = node.getPredicate();
        if (predicate != null) {
            predicate = (ISearchPredicate)((Object)predicate.getNode().accept(visitor));
        }
        if (node.isGenerating()) {
            ISearchPredicate indexPredicate;
            if (visitor.getReferencedDatasets().isEmpty() && (indexPredicate = (ISearchPredicate)Modules.resolveWildcardedIndexes(this.resolver, new Dataset("index", "*"), PredicateType.SEARCH)) != null) {
                predicate = predicate == null ? indexPredicate : (ISearchPredicate)predicate.and(indexPredicate);
            }
            return new SearchCommand(predicate);
        }
        CommandNode sourceNode = node.getSource().accept(this);
        return new SearchCommand(sourceNode, predicate);
    }

    @Override
    public CommandNode visit(MStatsCommand node) {
        ISearchPredicate indexPredicate;
        IndexQualifierVisitor visitor = new IndexQualifierVisitor(this.resolver, "metric");
        ISearchPredicate predicate = (ISearchPredicate)node.getPredicate();
        if (predicate != null) {
            predicate = (ISearchPredicate)((Object)predicate.getNode().accept(visitor));
        }
        if (visitor.getReferencedDatasets().isEmpty() && (indexPredicate = (ISearchPredicate)Modules.resolveWildcardedIndexes(this.resolver, new Dataset("metric", "*"), PredicateType.SEARCH)) != null) {
            predicate = predicate == null ? indexPredicate : (ISearchPredicate)predicate.and(indexPredicate);
        }
        return new MStatsCommand(node.getAggregates(), node.getByFields().toArray(new IGroupBy[0]), predicate);
    }

    @Override
    public CommandNode visit(TStatsCommand node) {
        ISearchPredicate indexPredicate;
        IndexQualifierVisitor visitor = new IndexQualifierVisitor(this.resolver, "index");
        ISearchPredicate predicate = (ISearchPredicate)node.getPredicate();
        if (predicate != null) {
            predicate = (ISearchPredicate)((Object)predicate.getNode().accept(visitor));
        }
        if (visitor.getReferencedDatasets().isEmpty() && (indexPredicate = (ISearchPredicate)Modules.resolveWildcardedIndexes(this.resolver, new Dataset("index", "*"), PredicateType.SEARCH)) != null) {
            predicate = predicate == null ? indexPredicate : (ISearchPredicate)predicate.and(indexPredicate);
        }
        return new TStatsCommand(node.getAggregates(), node.getByFields(), predicate);
    }

    @Override
    public CommandNode visit(McatalogCommand node) {
        IWherePredicate indexPredicate;
        IndexQualifierVisitor visitor = new IndexQualifierVisitor(this.resolver, "metric");
        IWherePredicate predicate = (IWherePredicate)node.getPredicate();
        if (predicate != null) {
            predicate = (IWherePredicate)((Object)predicate.getNode().accept(visitor));
        }
        if (visitor.getReferencedDatasets().isEmpty() && (indexPredicate = (IWherePredicate)Modules.resolveWildcardedIndexes(this.resolver, new Dataset("metric", "*"), PredicateType.WHERE)) != null) {
            predicate = predicate == null ? indexPredicate : (IWherePredicate)predicate.and(indexPredicate);
        }
        return new McatalogCommand(node.getAggregateNodes(), predicate, node.getByFields() != null ? node.getByFields().toArray(new IGroupBy[0]) : null, node.getPrestatsNode(), node.getAppendNode());
    }
}

