/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.IDatasetResolver;
import com.splunk.commons.providers.IPlanProvider;
import com.splunk.commons.providers.IndexPlanProvider;
import com.splunk.commons.providers.InputlookupPlanProvider;
import com.splunk.commons.providers.KafkaPlanProvider;
import com.splunk.commons.providers.MetricsCatalogPlanProvider;
import com.splunk.commons.providers.MetricsPlanProvider;
import com.splunk.commons.providers.PartitionedDatasetPlanProvider;
import com.splunk.commons.providers.SavedsearchPlanProvider;
import com.splunk.commons.providers.SqlPlanProvider;
import com.splunk.commons.providers.TransientDatasetPlanProvider;

public final class PlanProviderFactory {
    private PlanProviderFactory() {
    }

    public static IPlanProvider getPlanProvider(Dataset dataset, IDatasetResolver datasetResolver) {
        switch (dataset.getKind()) {
            case "unknown": {
                throw new IllegalArgumentException("Couldn't resolve dataset " + dataset + " from metadata catalog");
            }
            case "catalog": {
                return new MetricsCatalogPlanProvider();
            }
            case "index": {
                return new IndexPlanProvider();
            }
            case "kafka": {
                return new KafkaPlanProvider();
            }
            case "lookup": {
                return new InputlookupPlanProvider();
            }
            case "partitioned": {
                return new PartitionedDatasetPlanProvider(datasetResolver);
            }
            case "savedsearch": {
                return new SavedsearchPlanProvider();
            }
            case "sql": {
                return new SqlPlanProvider();
            }
            case "metric": {
                return new MetricsPlanProvider();
            }
            case "transient": {
                return new TransientDatasetPlanProvider(datasetResolver);
            }
        }
        throw new IllegalArgumentException("Couldn't find a provider for dataset: " + dataset);
    }
}

