/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.datasets.BaseDataset;
import com.splunk.commons.datasets.Properties;
import com.splunk.commons.datasets.Property;
import org.bson.types.ObjectId;

public class KafkaDataset
extends BaseDataset {
    private static final String KIND = "kafka";
    private boolean finalized;

    public KafkaDataset(ObjectId id, String module, String name, String owner, Properties properties) {
        super(id, module, name, KIND, owner, properties == null ? KafkaDataset.getDefaultProperties() : properties);
    }

    private static Properties getDefaultProperties() {
        Properties props = new Properties();
        props.add(new Property("bootstrap.servers", "localhost:9092"));
        props.add(new Property("group.id", "3"));
        props.add(new Property("key.serializer", "org.apache.kafka.common.serialization.StringSerializer"));
        props.add(new Property("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer"));
        props.add(new Property("value.serializer", "org.apache.kafka.common.serialization.StringSerializer"));
        props.add(new Property("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer"));
        return props;
    }

    @Override
    public boolean validateProperties() {
        return this.getProperties().getProperty("bootstrap.server") != null && this.getProperties().getProperty("group.id") != null;
    }

    public String getTopic() {
        return this.getName();
    }
}

