/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.datasets.BaseField;
import com.splunk.commons.datasets.DataType;
import com.splunk.commons.datasets.IField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;

public class Fields
implements Iterable<IField> {
    private final List<IField> fields = new ArrayList<IField>();
    private boolean finalized;
    private final HashMap<String, Integer> fieldOrdinalMap = new HashMap();

    public Fields() {
    }

    public Fields(String[] fieldNames) {
        for (String name : fieldNames) {
            this.add(new BaseField(name, DataType.STRING));
        }
    }

    public Fields(IField field) {
        this.add(field);
        this.finalize();
    }

    public Fields(Iterable<IField> fields) {
        this.addAll(fields);
        this.finalize();
    }

    public Fields(IField[] fields) {
        this.addAll(Arrays.asList(fields));
        this.finalize();
    }

    public void finalize() {
        if (this.finalized) {
            throw new RuntimeException("Dataset can only be finalized once.");
        }
        this.finalized = true;
    }

    public void finalize(Iterable<IField> fields) {
        if (this.finalized) {
            throw new RuntimeException("Dataset can only be finalized once.");
        }
        this.addAll(fields);
        this.finalize();
    }

    private void addAll(Iterable<IField> fields) {
        for (IField field : fields) {
            this.add(field);
        }
    }

    public void addAll(String[] fieldNames) {
        for (String name : fieldNames) {
            this.add(new BaseField(name, DataType.STRING));
        }
    }

    public void add(IField field) {
        if (this.finalized) {
            throw new RuntimeException("Can't add to a finalized collection.");
        }
        if (this.fieldOrdinalMap.containsKey(field.getName())) {
            int idx = this.fieldOrdinalMap.get(field.getName());
            IField original = this.fields.get(idx);
            IField merged = BaseField.merge(original, field);
            this.fields.set(idx, field);
        } else {
            this.fieldOrdinalMap.put(field.getName(), this.fields.size());
            this.fields.add(field);
        }
    }

    @Override
    public Iterator<IField> iterator() {
        return this.fields.iterator();
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public int getOrdinal(String fieldName) {
        if (!this.fieldOrdinalMap.containsKey(fieldName)) {
            return -1;
        }
        return this.fieldOrdinalMap.get(fieldName);
    }

    public int size() {
        return this.fields.size();
    }

    public IField getField(String name) {
        if (this.fieldOrdinalMap.containsKey(name)) {
            return this.fields.get(this.fieldOrdinalMap.get(name));
        }
        return null;
    }

    public IField getField(int ordinal) {
        if (ordinal < 0 || ordinal > this.fields.size() - 1) {
            return null;
        }
        return this.fields.get(ordinal);
    }

    public static Fields merge(Fields left, Fields right) {
        Fields fields = new Fields();
        for (IField l : left) {
            fields.add(l);
        }
        for (IField r : right) {
            fields.add(r);
        }
        fields.finalize();
        return fields;
    }

    public List<IField> getFields() {
        return this.fields;
    }

    public JSONArray getJSONArray() {
        JSONArray array = new JSONArray();
        for (IField field : this) {
            array.put((Object)field.getJSON());
        }
        return array;
    }

    public static String[] getFieldNames(Iterable<IField> fields) {
        ArrayList<String> names = new ArrayList<String>();
        for (IField field : fields) {
            names.add(field.getName());
        }
        return names.toArray(new String[0]);
    }

    public static Fields load(JSONArray array) {
        if (array == null) {
            return new Fields();
        }
        IField[] fields = new BaseField[array.length()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = BaseField.load(array.getJSONObject(i));
        }
        return new Fields(fields);
    }

    public static JSONArray getJSON(Iterable<IField> fields) {
        JSONArray jsonArray = new JSONArray();
        if (fields != null) {
            for (IField field : fields) {
                jsonArray.put((Object)field.getJSON());
            }
        }
        return jsonArray;
    }
}

