/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.Unknown;
import com.splunk.commons.datasets.ConstantField;
import com.splunk.commons.datasets.DataType;
import com.splunk.commons.datasets.IField;
import com.splunk.commons.util.SafeArgs;
import org.json.JSONObject;

public class BaseField
implements IField {
    private final String name;
    private final DataType dataType;

    public BaseField(String name, DataType dataType) {
        this.name = SafeArgs.valueIsNotNull(name, "The name must not be null");
        this.dataType = SafeArgs.valueIsNotNull(dataType, "The dataType must not be null");
    }

    public BaseField(String name) {
        this.name = SafeArgs.valueIsNotNull(name, "The name must not be null");
        this.dataType = DataType.STRING;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public static IField load(JSONObject jsonObject) {
        assert (!jsonObject.isNull("name") && !jsonObject.isNull("dataType"));
        String name = jsonObject.getString("name");
        DataType dataType = DataType.fromString(jsonObject.getString("dataType"));
        Object value = jsonObject.opt("value");
        if (value == null) {
            return new BaseField(name, dataType);
        }
        if (value.equals("*")) {
            value = Unknown.VALUE;
        }
        return new ConstantField(name, dataType, value);
    }

    @Override
    public JSONObject getJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)this.name);
        jsonObject.put("dataType", (Object)this.dataType.stringValue());
        return jsonObject;
    }

    public static IField merge(IField left, IField right) {
        if (!left.getName().equals(right.getName())) {
            throw new IllegalArgumentException("Can't merge fields with different names.");
        }
        if (left.getName().equals("*")) {
            return left;
        }
        if (left instanceof ConstantField) {
            if (right instanceof ConstantField) {
                ConstantField l = (ConstantField)left;
                ConstantField r = (ConstantField)right;
                if (!l.getValue().equals(r.getValue())) {
                    throw new IllegalStateException("Can't merge two fields that are both constants, until multi-value fields are supported.");
                }
            }
            return left;
        }
        if (right instanceof ConstantField) {
            return right;
        }
        if (left.getDataType() != right.getDataType()) {
            return new BaseField(left.getName(), DataType.UNKNOWN);
        }
        return left;
    }
}

