/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;

public class MeasureNode
extends TypeNode {
    private final MeasureReference reference;

    public MeasureNode() {
        this("*", "_value");
    }

    public MeasureNode(String reference) {
        super("measure");
        this.reference = new MeasureReference(reference);
    }

    private MeasureNode(String metricName, String measureName) {
        super("measure");
        this.reference = new MeasureReference(metricName, measureName);
    }

    private static String createReference(String metricName, String measureName) {
        MeasureNode.assertParamNotNull(metricName, "metricName");
        MeasureNode.assertParamNotNull(measureName, "measureName");
        if (metricName.equals("*")) {
            return measureName;
        }
        if (measureName.equals("_value")) {
            return metricName + ':';
        }
        return String.format("%1$s:%2$s", metricName, measureName);
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public MeasureReference getReference() {
        return this.reference;
    }

    public class MeasureReference {
        private final String metricName;
        private final String measureName;

        public MeasureReference() {
            this("*", "_value");
        }

        private MeasureReference(String metricName, String measureName) {
            MeasureNode.assertParamNotNull(metricName, "metricName");
            MeasureNode.assertParamNotNull(metricName, "measureName");
            this.metricName = metricName;
            this.measureName = measureName;
        }

        private MeasureReference(String reference) {
            MeasureNode.assertParamNotNull(reference, "reference");
            String[] parts = reference.split(":");
            if (parts.length > 2) {
                throw new IllegalArgumentException("Malformed measure reference.");
            }
            if (parts.length == 1) {
                this.metricName = "*";
                this.measureName = parts[0].equals("") ? "_value" : parts[0];
            } else {
                this.metricName = parts[0];
                this.measureName = parts[1].equals("") ? "_value" : parts[1];
            }
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getMeasureName() {
            return this.measureName;
        }

        public String toString() {
            return MeasureNode.createReference(this.metricName, this.measureName);
        }
    }
}

