/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;

public class AssignmentNode
extends TypeNode
implements ISelection {
    private final FieldNode field;
    private final TypeNode expression;
    private final int bracketIndex;

    public AssignmentNode(FieldNode field, TypeNode expression) {
        this(field, expression, -1);
    }

    public AssignmentNode(String fieldName, TypeNode expression) throws IllegalArgumentException {
        this(new FieldNode(fieldName), expression);
    }

    public AssignmentNode(FieldNode field, TypeNode expression, int bracketIndex) {
        super("assignment");
        if (expression instanceof IWherePredicate) {
            throw new IllegalArgumentException("Cannot assign a boolean expression to a field. Consider using if(..) or case(..).");
        }
        this.field = field;
        this.expression = expression;
        this.bracketIndex = bracketIndex;
    }

    public String getFieldName() {
        return this.field.getFieldName();
    }

    public FieldNode getField() {
        return this.field;
    }

    public TypeNode getExpression() {
        return this.expression;
    }

    public int getBracketIndex() {
        return this.bracketIndex;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public TypeNode getTypeNode() {
        return this;
    }

    public AssignmentNodeArray and(String fieldName, TypeNode expression) {
        return this.and(Expression.assignment(fieldName, expression));
    }

    public AssignmentNodeArray and(AssignmentNode assignment) {
        return new AssignmentNodeArray().and(this).and(assignment);
    }

    public AssignmentNode[] array() {
        return new AssignmentNode[]{this};
    }

    public final class AssignmentNodeArray {
        private final ArrayList<AssignmentNode> assignments = new ArrayList();

        private AssignmentNodeArray() {
        }

        private AssignmentNodeArray and(AssignmentNode assignment) {
            this.assignments.add(assignment);
            return this;
        }

        public AssignmentNodeArray and(String fieldName, TypeNode expression) {
            return this.and(Expression.assignment(fieldName, expression));
        }

        public AssignmentNode[] array() {
            return this.assignments.toArray(new AssignmentNode[this.assignments.size()]);
        }
    }
}

