/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IFilteringCommand;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.Predicate;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchInNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class SearchCommand
extends CommandNode
implements IFilteringCommand {
    private static final long serialVersionUID = 1L;
    private final ISearchPredicate predicate;

    public SearchCommand(CommandNode source, IPredicate predicate) {
        super(source, "search", CommandType.SP_STREAM, new FieldsAndProperties().search(Predicate.search(predicate)).array());
        this.predicate = SearchCommand.wrapIfNecessary(Predicate.search(predicate));
    }

    public SearchCommand(IPredicate predicate) {
        super("search", CommandType.SP_STREAM, new FieldsAndProperties().generatingSearch().search(Predicate.search(predicate)).array());
        this.predicate = SearchCommand.wrapIfNecessary(Predicate.search(predicate));
    }

    public SearchCommand() {
        super("search", CommandType.SP_STREAM, new FieldsAndProperties().generatingSearch().array());
        this.predicate = new SearchAndNode(new ISearchPredicate[0]);
    }

    private static ISearchPredicate wrapIfNecessary(ISearchPredicate predicate) {
        if (predicate.getNode() instanceof SearchAndNode || predicate.getNode() instanceof SearchOrNode || predicate.getNode() instanceof SearchInNode || predicate.getNode() instanceof SearchXorNode) {
            return predicate;
        }
        return new SearchAndNode(predicate);
    }

    @Override
    public IPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public CommandNode getCommand() {
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new SearchCommand(source, this.predicate);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }
}

