/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;

public final class RexCommand
extends CommandNode {
    public static final int DEFAULT_MAX_MATCH = 1;
    public static final int UNLIMITED_MAX_MATCH = 0;
    private static final FieldNode DEFAULT_FIELD = new FieldNode("_raw");
    private final boolean sedMode;
    private final String sedExpression;
    private final FieldNode field;
    private final String regexExpression;
    private final FieldNode offsetField;
    private final int maxMatch;

    private RexCommand(CommandNode source, String sedExpression, FieldNode field) {
        super(source, "rex", CommandType.SP_STREAM, new FieldsAndProperties().modified(field == null ? DEFAULT_FIELD.getFieldName() : field.getFieldName()).array());
        this.sedExpression = sedExpression;
        this.field = field;
        this.sedMode = true;
        this.regexExpression = null;
        this.offsetField = null;
        this.maxMatch = 0;
    }

    private RexCommand(CommandNode source, String regexExpression, FieldNode field, FieldNode offsetField, int maxMatch) {
        super(source, "rex", CommandType.SP_STREAM, new FieldsAndProperties().referenced(field == null ? DEFAULT_FIELD.getFieldName() : field.getFieldName()).rex(regexExpression, offsetField == null ? null : offsetField.getFieldName()).array());
        this.regexExpression = regexExpression;
        this.field = field;
        this.offsetField = offsetField;
        this.maxMatch = maxMatch;
        this.sedMode = false;
        this.sedExpression = null;
    }

    public static RexCommand rex(CommandNode source, String regexExpression) {
        return new RexCommand(source, regexExpression, DEFAULT_FIELD, null, 1);
    }

    public static RexCommand rex(CommandNode source, String regexExpression, FieldNode field) {
        return new RexCommand(source, regexExpression, field, null, 1);
    }

    public static RexCommand rex(CommandNode source, String regexExpression, FieldNode field, FieldNode offsetField, int maxMatch) {
        return new RexCommand(source, regexExpression, field, offsetField, maxMatch);
    }

    public static RexCommand sed(CommandNode source, String sedExpression) {
        return new RexCommand(source, sedExpression, DEFAULT_FIELD);
    }

    public static RexCommand sed(CommandNode source, String sedExpression, FieldNode field) {
        return new RexCommand(source, sedExpression, field);
    }

    public boolean isSedMode() {
        return this.sedMode;
    }

    public String getSedExpression() {
        return this.sedExpression;
    }

    public FieldNode getField() {
        return this.field;
    }

    public String getRegexExpression() {
        return this.regexExpression;
    }

    public FieldNode getOffsetField() {
        return this.offsetField;
    }

    public int getMaxMatch() {
        return this.maxMatch;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        if (this.sedMode) {
            return new RexCommand(source, this.sedExpression, this.field);
        }
        return new RexCommand(source, this.regexExpression, this.field, this.offsetField, this.maxMatch);
    }
}

