/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.visitors.NodeVisitor;

public class RegexCommand
extends CommandNode {
    private final String fieldName;
    private final Operator operator;
    private final String regex;

    public RegexCommand(CommandNode source, String fieldName, Operator operator, String regex) {
        super(source, "regex", CommandType.SP_STREAM, new FieldsAndProperties().referenced(fieldName).array());
        RegexCommand.assertNotNull(fieldName);
        RegexCommand.assertTrue(operator == Operator.EQUAL || operator == Operator.NOT_EQUAL);
        this.fieldName = fieldName;
        this.operator = operator;
        this.regex = regex;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getRegex() {
        return this.regex;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new RegexCommand(source, this.fieldName, this.operator, this.regex);
    }
}

