/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.ParamNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class FitCommand
extends CommandNode {
    private final StringNode algorithm;
    private final FieldNode targetfield;
    private final FieldNode[] featuredfields;
    private final ParamNode[] params;
    private final StringNode modelname;
    private final FieldNode outputfield;

    public FitCommand(CommandNode source, StringNode algorithm, FieldNode targetfield, FieldNode[] featuredfields, ParamNode[] params, StringNode modelname, FieldNode outputfield) {
        super(source, "fit", CommandType.SP_REPORT, new FieldsAndProperties().array());
        this.algorithm = algorithm;
        this.targetfield = targetfield;
        this.featuredfields = featuredfields;
        this.params = params;
        this.modelname = modelname;
        this.outputfield = outputfield;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    private StringNode getAlgorithm() {
        return this.algorithm;
    }

    private FieldNode getTragetField() {
        return this.targetfield;
    }

    private FieldNode getOutputField() {
        return this.outputfield;
    }

    private FieldNode[] getFeatureFields() {
        return this.featuredfields;
    }

    private ParamNode[] getParams() {
        return this.params;
    }

    private StringNode getModelName() {
        return this.modelname;
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new FitCommand(source, this.algorithm, this.targetfield, this.featuredfields, this.params, this.modelname, this.outputfield);
    }

    public String getSPL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.algorithm.getValue());
        ParamNode[] params = this.getParams();
        if (params != null && params.length != 0) {
            CharSequence[] fieldsst = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                fieldsst[i] = params[i].toString();
            }
            String fields = String.join((CharSequence)" ", fieldsst);
            buffer.append(' ').append(fields);
        }
        buffer.append(' ');
        buffer.append(this.targetfield.getFieldName());
        FieldNode[] fieldsnodes = this.getFeatureFields();
        if (fieldsnodes != null && fieldsnodes.length != 0) {
            CharSequence[] fieldsst = new String[fieldsnodes.length];
            for (int i = 0; i < fieldsnodes.length; ++i) {
                fieldsst[i] = fieldsnodes[i].getFieldName();
            }
            String fields = String.join((CharSequence)", ", fieldsst);
            buffer.append(" from ").append(fields);
        }
        if (this.modelname != null && this.modelname.getValue() != "") {
            buffer.append(" into ").append(this.modelname.getValue());
        }
        if (this.outputfield != null && this.outputfield.getFieldName() != "") {
            buffer.append(" as ").append(this.outputfield.getFieldName());
        }
        return buffer.toString();
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }
}

