/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.commons.ast.nodes.expressions.JoinType;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.visitors.ReferencedFieldsVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FieldsAndProperties {
    public static final FieldProperties[] DEFAULT = new FieldProperties[0];
    private final Set<String> fields = new HashSet<String>();
    private final Set<String> modified = new HashSet<String>();
    private final Set<String> referenced = new HashSet<String>();
    private final Set<String> removed = new HashSet<String>();
    private final Set<String> filterable = new HashSet<String>();

    public FieldsAndProperties() {
    }

    public FieldsAndProperties(FieldProperties[] properties) {
        for (FieldProperties property : properties) {
            this.append(property);
        }
    }

    public FieldsAndProperties field(String field, boolean modified, boolean referenced, boolean removed, boolean filterable) {
        this.fields.add(field);
        if (modified) {
            this.modified(field);
        }
        if (referenced) {
            this.referenced(field);
        }
        if (removed) {
            this.removed(field);
        }
        if (filterable) {
            this.filterable(field);
        }
        return this;
    }

    public FieldsAndProperties field(String field) {
        this.fields.add(field);
        return this;
    }

    private FieldsAndProperties append(FieldProperties property) {
        this.field(property.getName(), property.getModified(), property.getReferenced(), property.getRemoved(), property.getFilterable());
        return this;
    }

    public FieldsAndProperties modified(String field) {
        this.field(field);
        this.modified.add(field);
        return this;
    }

    public FieldsAndProperties referenced(String field) {
        this.field(field);
        this.referenced.add(field);
        return this;
    }

    private FieldsAndProperties removed(String field) {
        this.field(field);
        this.removed.add(field);
        return this;
    }

    private FieldsAndProperties filterable(String field) {
        this.field(field);
        this.filterable.add(field);
        return this;
    }

    public boolean isField(String field) {
        return this.fields.contains(field);
    }

    public boolean isModified(String field) {
        return this.modified.contains(field);
    }

    public boolean isReferenced(String field) {
        return this.referenced.contains(field);
    }

    public boolean isRemoved(String field) {
        return this.removed.contains(field);
    }

    public boolean isFilterable(String field) {
        return this.filterable.contains(field);
    }

    public Set<String> getModified() {
        return new HashSet<String>(this.modified);
    }

    public Set<String> getReferenced() {
        return new HashSet<String>(this.referenced);
    }

    public FieldsAndProperties where(IWherePredicate predicate) {
        if (predicate != null) {
            for (String field : ((Node)((Object)predicate)).accept(new ReferencedFieldsVisitor())) {
                this.referenced(field);
            }
        }
        return this;
    }

    public FieldsAndProperties generatingSearch() {
        this.field("*", true, false, false, false);
        return this;
    }

    public FieldsAndProperties search(ISearchPredicate predicate) {
        if (predicate != null) {
            for (String field : predicate.getNode().accept(new ReferencedFieldsVisitor())) {
                this.referenced(field);
            }
        }
        return this;
    }

    public FieldsAndProperties bin(String originalField) {
        this.field(originalField, false, true, false, false);
        return this;
    }

    public FieldsAndProperties bin(FieldNode originalField, FieldNode newField) {
        this.field(originalField.getFieldName(), false, false, false, false);
        if (newField != null) {
            this.field(newField.getFieldName(), true, false, false, false);
        }
        return this;
    }

    public FieldsAndProperties by(IGroupBy ... byFields) {
        if (byFields != null && byFields.length > 0) {
            for (IGroupBy node : byFields) {
                if (node == null) continue;
                for (String field : ((Node)((Object)node)).accept(new ReferencedFieldsVisitor())) {
                    if (field.equals("_time")) {
                        this.field(field, true, true, false, false);
                        continue;
                    }
                    this.field(field, true, true, false, true);
                }
            }
        }
        return this;
    }

    public FieldsAndProperties datamodel(String[] fields) {
        for (String field : fields) {
            this.field(field, true, false, false, false);
        }
        return this;
    }

    public FieldsAndProperties fields(FieldNode[] fields, boolean removeFields) {
        if (removeFields) {
            for (FieldNode field : fields) {
                this.field(field.getFieldName(), false, true, true, false);
            }
        } else {
            this.removed("*");
            this.filterable("_*");
            for (FieldNode field : fields) {
                this.field(field.getFieldName(), false, true, false, true);
            }
        }
        return this;
    }

    public FieldsAndProperties fields(FieldNode[] fields, boolean modified, boolean reference, boolean removed, boolean filterable) {
        if (fields != null) {
            for (FieldNode field : fields) {
                this.field(field.getFieldName(), modified, reference, removed, filterable);
            }
        }
        return this;
    }

    public FieldsAndProperties from(IWherePredicate where, IGroupBy[] groupBy, ISelection[] selections, IOrdering[] orderings) {
        return this.field("*").where(where).by(groupBy).select(selections).orderby(orderings);
    }

    public FieldsAndProperties orderby(IOrdering[] orderings) {
        if (orderings != null) {
            for (IOrdering o : orderings) {
                this.referenced(o.getField().getFieldName());
            }
        }
        return this;
    }

    private FieldsAndProperties select(ISelection[] selections) {
        if (selections != null) {
            for (ISelection s : selections) {
                if (s instanceof FieldNode) {
                    this.referenced(((FieldNode)s).getFieldName());
                    continue;
                }
                if (!(s instanceof AggregateNode)) continue;
                this.aggregate(new AggregateNode[]{(AggregateNode)s});
            }
        }
        return this;
    }

    public FieldsAndProperties timechart(StringNode sep, StringNode format, IGroupBy[] byFields, AggregateNode ... aggregates) {
        this.field("*", true, true, false, false);
        if (sep != null) {
            this.field(sep.toString(), true, true, false, false);
        }
        if (format != null) {
            this.field(format.toString(), true, true, false, false);
        }
        this.aggregate(aggregates).by(byFields);
        return this;
    }

    public FieldsAndProperties rex(String regex, String offsetField) {
        ArrayList<String> modifiedFields = new ArrayList<String>();
        char[] chars = regex.toCharArray();
        boolean escaping = false;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                escaping = true;
                continue;
            }
            if (chars[i] == '<' && !escaping) {
                start = i + 1;
                continue;
            }
            if (chars[i] == '>' && start != 0 && !escaping) {
                modifiedFields.add(new String(Arrays.copyOfRange(chars, start, i)));
                start = 0;
                continue;
            }
            if (!escaping) continue;
            escaping = false;
        }
        for (String modified : modifiedFields) {
            this.modified(modified);
            this.referenced(modified);
        }
        if (offsetField != null && !offsetField.equals("")) {
            this.modified(offsetField);
            this.referenced(offsetField);
        }
        return this;
    }

    public FieldsAndProperties aggregate(AggregateNode[] aggregates) {
        if (aggregates != null) {
            for (AggregateNode a : aggregates) {
                String field;
                this.modified(a.getAsName());
                if (a.getField() == null || (field = a.getField().getFieldName()).equals("")) continue;
                this.referenced(field);
            }
        }
        return this;
    }

    public FieldsAndProperties eval(AssignmentNode[] assignments) {
        ReferencedFieldsVisitor visitor = new ReferencedFieldsVisitor();
        for (AssignmentNode assignment : assignments) {
            this.modified(assignment.getFieldName());
            for (String referenced : assignment.getExpression().accept(visitor)) {
                this.referenced(referenced);
            }
        }
        return this;
    }

    public FieldsAndProperties iplocation(String ipField, String prefix, boolean allFields) {
        this.referenced(ipField);
        this.modified(prefix + "City");
        this.modified(prefix + "Country");
        this.modified(prefix + "Region");
        this.modified(prefix + "lat");
        this.modified(prefix + "long");
        if (allFields) {
            this.modified(prefix + "Continent");
            this.modified(prefix + "MetroCode");
            this.modified(prefix + "Timezone");
        }
        return this;
    }

    public FieldsAndProperties lookup(JoinNode[] joinKeys, JoinNode[] selections) {
        for (JoinNode joinKey : joinKeys) {
            this.referenced(joinKey.getLeftSide().getFieldName());
        }
        if (selections == null || selections.length == 0) {
            this.modified("*");
        } else {
            for (JoinNode selection : selections) {
                this.modified(selection.getLeftSide().getFieldName());
            }
        }
        return this;
    }

    public FieldsAndProperties join(JoinType type, JoinNode[] joinClauses, boolean overwrite, String lhsAlias, String rhsAlias) {
        if (JoinCommand.isV2(joinClauses, lhsAlias, rhsAlias)) {
            this.removed("*");
            for (JoinNode joinClause : joinClauses) {
                String left = joinClause.getLeftSide().getFieldName();
                this.referenced(left);
                this.removed(left);
            }
            this.modified(lhsAlias + ".*");
            if (type == JoinType.INNER || type == JoinType.LEFT) {
                this.filterable(lhsAlias + ".*");
            }
            this.modified(rhsAlias + ".*");
            if (type == JoinType.INNER || type == JoinType.RIGHT) {
                this.filterable(rhsAlias + ".*");
            }
        } else {
            for (JoinNode jn : joinClauses) {
                String referencedField = jn.getCommonFieldName();
                this.referenced(referencedField);
                if (!overwrite) continue;
                this.modified(referencedField);
            }
        }
        return this;
    }

    public FieldsAndProperties mstats(AggregateNode[] aggregates, IGroupBy[] byFields, ISearchPredicate where) {
        return this.tstats(aggregates, byFields, where);
    }

    public FieldsAndProperties rename(RenameNode[] renames) {
        for (RenameNode rename : renames) {
            this.field(rename.getFieldName(), false, true, true, false);
            this.field(rename.getNewFieldName(), true, false, false, false);
        }
        return this;
    }

    public FieldsAndProperties table(FieldNode[] fields) {
        this.field("*", false, false, true, false);
        for (FieldNode field : fields) {
            this.field(field.getFieldName(), true, true, false, true);
        }
        return this;
    }

    public FieldsAndProperties tstats(AggregateNode[] aggregates, IGroupBy[] byFields, ISearchPredicate where) {
        return this.aggregate(aggregates).by(byFields).search(where);
    }

    public FieldsAndProperties union(CommandNode[] sources) {
        this.filterable("*");
        return this;
    }

    public int size() {
        return this.fields.size();
    }

    public void clear() {
        this.fields.clear();
        this.modified.clear();
        this.referenced.clear();
        this.removed.clear();
        this.filterable.clear();
    }

    public FieldProperties[] array() {
        ArrayList<FieldProperties> metadata = new ArrayList<FieldProperties>();
        for (String field : this.fields) {
            metadata.add(new FieldProperties(field, this.modified.contains(field), this.referenced.contains(field), this.removed.contains(field), this.filterable.contains(field)));
        }
        return metadata.toArray(new FieldProperties[0]);
    }
}

