/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class DedupCommand
extends CommandNode {
    public static final int DEFAULT_LIMIT = 1;
    public static final boolean DEFAULT_STREAMING = false;
    public static final boolean DEFAULT_CONSECUTIVE = false;
    public static final boolean DEFAULT_KEEPEVENTS = false;
    public static final boolean DEFAULT_KEEPEMPTY = false;
    public static final boolean DEFAULT_PREDEDUP_MODE = false;
    private final FieldNode[] fields;
    private final boolean consecutive;
    private final boolean keepevents;
    private final boolean keepempty;
    private final int limit;
    private String[] requiredFields;
    private final boolean preDedupMode;
    private final IOrdering[] sortBy;

    public DedupCommand(CommandNode source, int limit) {
        this(source, limit, null, false, false, false, null, false);
    }

    public DedupCommand(CommandNode source, int limit, FieldNode[] fields) {
        this(source, limit, fields, false, false, false, null, false);
    }

    public DedupCommand(CommandNode source, FieldNode[] fields) {
        this(source, 1, fields, false, false, false, null, false);
    }

    public DedupCommand(CommandNode source, int limit, FieldNode[] fields, boolean keepevents, boolean keepempty, boolean consecutive, IOrdering[] sortBy, boolean preDedupMode) {
        super(source, "dedup", preDedupMode ? CommandType.SP_STREAM : CommandType.SP_STATEFUL, new FieldsAndProperties().fields(fields, false, true, false, false).orderby(sortBy).array());
        this.limit = limit;
        this.fields = fields;
        this.keepevents = keepevents;
        this.keepempty = keepempty;
        this.consecutive = consecutive;
        this.preDedupMode = preDedupMode;
        this.sortBy = sortBy;
    }

    public int getLimit() {
        return this.limit;
    }

    public FieldNode[] getFields() {
        return this.fields;
    }

    public boolean isKeepEmpty() {
        return this.keepempty;
    }

    public boolean isKeepEvents() {
        return this.keepevents;
    }

    public boolean isConsecutive() {
        return this.consecutive;
    }

    @Deprecated
    public IOrdering[] getSortBy() {
        return this.sortBy;
    }

    public boolean isPreDedupMode() {
        return this.preDedupMode;
    }

    public CommandNode convertToPreDedup(CommandNode source) {
        DedupCommand dedup = new DedupCommand(source, this.limit, this.fields, this.keepevents, this.keepempty, this.consecutive, this.sortBy, true);
        return dedup;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new DedupCommand(source, this.limit, this.fields, this.keepevents, this.keepempty, this.consecutive, this.sortBy, this.preDedupMode);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }
}

