/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.visitors.NodeVisitor;

public class AppendCommand
extends CommandNode {
    public AppendCommand(CommandNode leftSource, CommandNode rightSource) throws IllegalArgumentException {
        super(new CommandNode[]{leftSource, rightSource}, "append", CommandType.SP_EVENTS, FieldsAndProperties.DEFAULT);
        if (leftSource == null || rightSource == null) {
            throw new IllegalArgumentException("Left and right sources must both be not null.");
        }
    }

    public CommandNode getLeftSource() {
        return this.getSources()[0];
    }

    public CommandNode getRightSource() {
        return this.getSources()[1];
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSources(CommandNode[] sources) {
        AppendCommand.assertTrue(sources.length == 2);
        return new AppendCommand(sources[0], sources[1]);
    }
}

