/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandOrderInfo;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.RdInCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.ReverseCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.visitors.CommandRebuilder;
import com.splunk.df.search.compute.ComputeEngineConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class OrderInfoVisitor
extends CommandRebuilder {
    static final Logger logger = Logger.getLogger(OrderInfoVisitor.class);
    private ArrayList<CommandOrderInfo> commandOrderInfo = new ArrayList();

    public OrderInfoVisitor() {
        this.commandOrderInfo.add(new CommandOrderInfo());
    }

    public ArrayList<CommandOrderInfo> getPipelineOrderInfo() {
        return this.commandOrderInfo;
    }

    private void reset() {
        this.commandOrderInfo.clear();
    }

    private void setOrderInfo(CommandNode node) {
        if (node.getCommandType().ordinal() > CommandType.SP_EVENTS.ordinal()) {
            this.reset();
        }
    }

    private void dedup() {
        HashSet<String> fields = new HashSet<String>();
        Iterator<CommandOrderInfo> it = this.commandOrderInfo.iterator();
        while (it.hasNext()) {
            String field = it.next().getOrderField();
            if (!fields.isEmpty() && fields.contains(field)) {
                it.remove();
                continue;
            }
            fields.add(field);
        }
    }

    public CommandNode visit(CommandNode node) {
        super.visit(node);
        this.setOrderInfo(node);
        return node;
    }

    public CommandNode visit(StatsCommand node) {
        List byFields;
        super.visit((CommandNode)node);
        this.setOrderInfo((CommandNode)node);
        if (!node.isPrestatsMode() && (byFields = node.getByFields()) != null) {
            for (IGroupBy groupBy : byFields) {
                CommandOrderInfo co = new CommandOrderInfo();
                co.reset();
                co.setOrderField(groupBy.getByName());
                co.setOrder(true);
                this.commandOrderInfo.add(co);
            }
        }
        return node;
    }

    public CommandNode visit(RenameCommand node) {
        super.visit((CommandNode)node);
        RenameNode[] renames = node.getRenames();
        for (int ci = 0; ci < this.commandOrderInfo.size(); ++ci) {
            for (int i = 0; i < renames.length; ++i) {
                if (renames[i].getFieldName() != this.commandOrderInfo.get(ci).getOrderField()) continue;
                CommandOrderInfo co = new CommandOrderInfo();
                co.reset();
                co.setOrderField(renames[i].getNewFieldName());
                co.setOrder(this.commandOrderInfo.get(ci).getOrder());
                this.commandOrderInfo.set(ci, co);
            }
        }
        this.dedup();
        return node;
    }

    public CommandNode visit(FieldsCommand node) {
        super.visit((CommandNode)node);
        if (node.isKeepColumnOrder()) {
            return node;
        }
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>(Arrays.asList(node.getFields()));
        if (fields.isEmpty()) {
            return node;
        }
        Iterator<CommandOrderInfo> it = this.commandOrderInfo.iterator();
        while (it.hasNext()) {
            String field = it.next().getOrderField();
            if (node.isRemoveFields() != fields.contains(field)) continue;
            it.remove();
        }
        return node;
    }

    public CommandNode visit(RdInCommand node) {
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(RdOutCommand node) {
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(ReverseCommand node) {
        super.visit((CommandNode)node);
        for (CommandOrderInfo co : this.commandOrderInfo) {
            co.setOrder(!co.getOrder());
        }
        return node;
    }

    public CommandNode visit(SortCommand node) {
        super.visit((CommandNode)node);
        IOrdering[] ordering = node.getBy();
        if (ordering.length == 0) {
            return node;
        }
        this.reset();
        for (IOrdering order : ordering) {
            CommandOrderInfo co = new CommandOrderInfo();
            co.reset();
            co.setOrderField(order.getField().getFieldName());
            co.setOrder(order.getSortOrder() == SortOrder.ASC);
            this.commandOrderInfo.add(co);
        }
        return node;
    }

    public CommandNode visit(SearchCommand node) {
        super.visit((CommandNode)node);
        this.setOrderInfo((CommandNode)node);
        return node;
    }

    public CommandNode visit(EvalCommand node) {
        AssignmentNode[] assignments;
        super.visit((CommandNode)node);
        for (AssignmentNode assignmentNode : assignments = node.getAssignments()) {
            if (!assignmentNode.getFieldName().equals(ComputeEngineConstants.SPLUNK_TIME_FIELD.fieldName())) continue;
            this.reset();
            break;
        }
        return node;
    }

    public CommandNode visit(UnionCommand node) {
        super.visit((CommandNode)node);
        this.reset();
        return node;
    }
}

