/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import com.splunk.df.search.SplunkEvent;
import com.splunk.df.search.SplunkEventChunk;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;

public class Utils {
    static final Logger logger = Logger.getLogger(Utils.class);

    public static <T> T as(Class<T> t, Object o) {
        return t.isInstance(o) ? (T)t.cast(o) : null;
    }

    public static String decodeAndDecompress(String data) throws IOException, DataFormatException {
        byte[] dataBytes = Base64.decodeBase64((String)data);
        Inflater inf = new Inflater();
        inf.setInput(dataBytes);
        byte[] output = new byte[0x100000];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        do {
            len = inf.inflate(output);
            baos.write(output);
            Arrays.fill(output, (byte)0);
        } while (len == output.length);
        inf.end();
        baos.flush();
        String payload = new String(baos.toByteArray(), "UTF-8");
        baos.close();
        baos = null;
        payload = payload.trim();
        return payload;
    }

    public static String compressAndEncode(String payload) throws IOException {
        int len;
        long start = System.currentTimeMillis();
        byte[] payloadBytes = payload.getBytes();
        logger.debug((Object)("Length of payload bytes: " + payloadBytes.length));
        Deflater def = new Deflater(1);
        def.setInput(payloadBytes);
        def.finish();
        byte[] chunk = new byte[51200];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            len = def.deflate(chunk);
            baos.write(chunk, 0, len);
            Arrays.fill(chunk, (byte)0);
        } while (len == chunk.length);
        def.end();
        baos.flush();
        byte[] output = baos.toByteArray();
        baos.close();
        baos = null;
        logger.debug((Object)("Size of compressed data: " + output.length));
        String encoded = Base64.encodeBase64String((byte[])output);
        output = null;
        logger.debug((Object)("Size of compressed and encoded data: " + encoded.length()));
        logger.debug((Object)("Time to compress and encode: " + (System.currentTimeMillis() - start) + " millis"));
        return encoded;
    }

    public static boolean incompleteCsvLine(String line) {
        int idx = line.lastIndexOf(",\"");
        int idx1 = line.lastIndexOf("\"");
        return idx > 0 && idx1 <= idx + 1;
    }

    public static void printJvmStats(String prefix) {
        Runtime rt = Runtime.getRuntime();
        long mb = 0x100000L;
        long total = rt.totalMemory() / mb;
        long max = rt.maxMemory() / mb;
        long free = rt.freeMemory() / mb;
        logger.debug((Object)(prefix + ": total memory: " + total + "; max memory: " + max + "; free memory: " + free));
    }

    public static int getKeyIndex(String[] strs, String key) {
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (!str.equals(key)) continue;
            return i;
        }
        return -1;
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Throwable t) {
            logger.error((Object)("Error sleeping: " + t.getMessage()), t);
        }
    }

    public static void waitForData(BufferedReader br, String message) {
        try {
            logger.debug((Object)message);
            while (!br.ready()) {
                Utils.sleep(100L);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error while waiting for buffer to have data", t);
            throw new RuntimeException(t);
        }
    }

    public static void waitForData(BufferedReader br, String message, long millis) {
        try {
            while (!br.ready()) {
                Utils.sleep(millis);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error while waiting for buffer to have data", t);
        }
    }

    public static String readData(BufferedReader br, int size) throws IOException {
        if (size == 0) {
            return "";
        }
        char[] buff = new char[size];
        int totalRead = 0;
        while (true) {
            int charsRead;
            if (!br.ready()) {
                Utils.sleep(100L);
                continue;
            }
            if ((totalRead += (charsRead = br.read(buff, totalRead, size - totalRead))) == size) break;
        }
        return new String(buff);
    }

    public static SplunkEvent createEmptyEvent(String[] metadata) {
        Object[] data = new String[metadata.length];
        Arrays.fill(data, "");
        SplunkEvent event = new SplunkEvent(metadata, (String[])data);
        return event;
    }

    public static String toHex(String s) {
        return String.format("%040x", new BigInteger(1, s.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordChunk(String recordingFolder, SplunkEventChunk chunk) {
        File chunkFile = new File(recordingFolder + "/chunk-" + chunk.getSparkLookupCode() + "-" + chunk.getNumEvents() + "-" + System.currentTimeMillis());
        try {
            if (!chunkFile.createNewFile()) {
                logger.error((Object)("Could not record chunk to file: " + chunkFile.getAbsolutePath() + " because could not create new file"));
                return;
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Could not create chunk file: " + chunkFile.getAbsolutePath() + ": " + t.getMessage()), t);
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(chunkFile)));
            String data = Utils.decodeAndDecompress(chunk.getCompressedData());
            bw.write(data);
            bw.flush();
            logger.debug((Object)("Writen chunk file: " + chunkFile.getAbsolutePath() + " to disk"));
        }
        catch (Throwable t) {
            logger.error((Object)("Error while writing to chunk file: " + chunkFile.getAbsolutePath() + ": " + t.getMessage()), t);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Throwable t) {
                    logger.error((Object)("Error while closing chunk file writer: " + t.getMessage()), t);
                }
            }
        }
    }

    public static void appendCSVRecord(StringBuilder sb, CSVRecord rec) {
        int size = rec.size();
        for (int i = 0; i < size; ++i) {
            String field = rec.get(i);
            sb.append("\"" + field + "\"");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        sb.append("\n");
    }

    public static String toCSVString(CSVRecord rec) {
        StringBuilder sb = new StringBuilder();
        int size = rec.size();
        for (int i = 0; i < size; ++i) {
            String field = rec.get(i);
            sb.append("\"" + field + "\"");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            logger.error((Object)"Process is not alive");
            return false;
        }
    }

    public static boolean runCommand(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to run command, exception - ", t);
            return false;
        }
    }

    public static String getLocalHostAddress() {
        try {
            String ipAddr = InetAddress.getLocalHost().getHostAddress();
            logger.debug((Object)String.format("Localhost ip-address: %s", ipAddr));
            return ipAddr;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not getLocalHostAddress", t);
        }
    }

    public static String getIpFromEnv(String env, boolean defaultToLocalHost) {
        if (env == null || env.trim().length() == 0) {
            throw new RuntimeException("Host/IP env var is null or empty.");
        }
        String host = System.getenv(env);
        logger.debug((Object)("Host:" + host + " from env: " + env));
        if (host == null || host.trim().length() == 0) {
            if (defaultToLocalHost) {
                return Utils.getLocalHostAddress();
            }
            throw new RuntimeException("Host/IP env var: " + env + " is not set.");
        }
        try {
            return InetAddress.getByName(host.trim()).getHostAddress();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not get the ip address of the host:" + host, t);
        }
    }

    public static String getIpFromSplunkHostnameEnv() {
        return Utils.getIpFromEnv("SPLUNK_HOSTNAME", false);
    }

    public static SearchResult mergeMetaInfo(SearchResult sr, SearchResult metaInfo) {
        if (metaInfo == null || metaInfo.isEmpty()) {
            return sr;
        }
        ArrayList<SearchResult.FieldMeta> mf = new ArrayList<SearchResult.FieldMeta>();
        ArrayList<Object> mv = new ArrayList<Object>();
        for (int mi = 0; mi < metaInfo.getSize(); ++mi) {
            if (!metaInfo.getFieldNames()[mi].fieldName().startsWith("_")) continue;
            mf.add(metaInfo.getFieldNames()[mi]);
            mv.add(metaInfo.getFieldValues()[mi]);
        }
        if (mf.isEmpty()) {
            return sr;
        }
        return SearchResultFactory.getInstance().merge(sr, SearchResultFactory.getInstance().createSearchResult(mf.toArray(new SearchResult.FieldMeta[mf.size()]), mv.toArray(new Object[mv.size()])));
    }

    public static String[] getNonEmpty(String[] parts) {
        ArrayList<String> nonEmptyParts = new ArrayList<String>();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            nonEmptyParts.add(p);
        }
        return nonEmptyParts.toArray(new String[nonEmptyParts.size()]);
    }

    public static Double convertToDouble(String val) {
        if (val == null || val.length() == 0) {
            return null;
        }
        String nonDecimalPattern = "^(\\d+\\.){2}";
        Pattern pattern = Pattern.compile(nonDecimalPattern);
        Matcher matcher = pattern.matcher(val);
        if (matcher.find()) {
            return null;
        }
        boolean pointSeen = false;
        boolean eSeen = false;
        boolean numberSeen = false;
        StringBuilder builder = new StringBuilder();
        char cur = '\u0000';
        for (int i = 0; i < val.length(); ++i) {
            cur = val.charAt(i);
            if ('0' <= cur && cur <= '9') {
                numberSeen = true;
                builder.append(cur);
                continue;
            }
            if (cur == '.') {
                if (eSeen || pointSeen) break;
                pointSeen = true;
                builder.append(cur);
                continue;
            }
            if (cur == 'e' || cur == 'E') {
                if (!numberSeen || eSeen) break;
                eSeen = true;
                builder.append(cur);
                continue;
            }
            if (cur != '-' && cur != '+' || i != 0 && val.charAt(i - 1) != 'e' && val.charAt(i - 1) != 'E') break;
            builder.append(cur);
        }
        if (!numberSeen) {
            return null;
        }
        cur = builder.charAt(builder.length() - 1);
        if (builder.length() > 1 && (cur == '+' || cur == '-')) {
            builder.deleteCharAt(builder.length() - 1);
        }
        if ((cur = builder.charAt(builder.length() - 1)) == 'e' || cur == 'E') {
            builder.append(0);
        }
        return new Double(builder.toString());
    }

    public static void mergeMultiMap(HashMap<String, List<String>> to, HashMap<String, List<String>> from) {
        if (from.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : from.entrySet()) {
            if (to.containsKey(entry.getKey())) {
                List<String> toAdd = to.get(entry.getKey());
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    toAdd.add(entry.getValue().get(i));
                }
                continue;
            }
            to.put(entry.getKey(), entry.getValue());
        }
    }

    public static boolean isDownloadRemoteLogEnabled(ComputeEngineContext ctx) {
        return (Boolean)ctx.get(ComputeEngineConstants.FETCH_REMOTE_SEARCH_LOG.toString());
    }

    public static boolean updateHeaderFields(HashSet<SearchResult.FieldMeta> keys, SearchResult sr) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> srdata = sr.getDataMap();
        if (srdata.isEmpty()) {
            return false;
        }
        int count = keys.size();
        SearchResult.FieldMeta[] fieldArray = sr.getFieldNames();
        for (int i = 0; i < fieldArray.length; ++i) {
            keys.add(fieldArray[i]);
        }
        boolean keysChanged = false;
        if (keys.size() > count) {
            keysChanged = true;
        }
        return keysChanged;
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        int i;
        if (text == null || text.isEmpty() || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i2 = 0; i2 < searchLength; ++i2) {
            if (noMoreMatchesForReplIndex[i2] || searchList[i2] == null || searchList[i2].isEmpty() || replacementList[i2] == null) continue;
            tempIndex = i2 > 0 && i2 == searchLength - 1 ? text.lastIndexOf(searchList[i2]) : text.indexOf(searchList[i2]);
            if (i2 == 0 && tempIndex != 0) {
                return text;
            }
            if (i2 == searchLength - 1 && (tempIndex == -1 || tempIndex + searchList[i2].length() < text.length())) {
                return text;
            }
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i2] = true;
                continue;
            }
            if (textIndex != -1) continue;
            textIndex = tempIndex;
            replaceIndex = i2;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i3 = 0; i3 < searchList.length; ++i3) {
            int greater;
            if (searchList[i3] == null || replacementList[i3] == null || (greater = replacementList[i3].length() - searchList[i3].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        block2: while (textIndex != -1) {
            for (int i4 = start; i4 < textIndex; ++i4) {
                buf.append(text.charAt(i4));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            int replacedIndex = replaceIndex + 1;
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            for (i = replacedIndex; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
                tempIndex = i > 0 && i == searchLength - 1 ? text.lastIndexOf(searchList[i]) : text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1) continue;
                textIndex = tempIndex;
                replaceIndex = i;
                continue block2;
            }
        }
        int textLength = text.length();
        for (i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        return result;
    }
}

