/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateUtils;

public class TimeInterval {
    public static long ONE_YEAR = 31536000L;
    public static long ONE_MONTH = 2592000L;
    public static long ONE_DAY = 86400L;
    public static long ONE_HOUR = 3600L;
    public static long FIVE_MINUTES = 300L;
    public static long TEN_MINUTES = 600L;
    public static long ONE_MINUTE = 60L;
    private int timeQty;
    private TIMEUNIT timeUnit;
    static final String TIME_INTERVAL_REGEX = "(\\d+)([a-zA-Z]*)";
    static final Pattern timeIntervalPattern = Pattern.compile("(\\d+)([a-zA-Z]*)");

    private static TIMEUNIT getTimeUnit(String timeUnitStr) {
        String defaultTimeUnitStr = new String("s");
        if (timeUnitStr.isEmpty()) {
            timeUnitStr = defaultTimeUnitStr;
        }
        return TimeInterval.normalizeTimeUnit(TIMEUNIT.valueOf(timeUnitStr.toUpperCase()));
    }

    private static TIMEUNIT normalizeTimeUnit(TIMEUNIT timeUnit) {
        TIMEUNIT result = null;
        switch (timeUnit) {
            case SECONDS: 
            case SECOND: 
            case S: 
            case SECS: {
                result = TIMEUNIT.SECOND;
                break;
            }
            case MIN: 
            case M: 
            case MINS: 
            case MINUTE: 
            case MINUTES: {
                result = TIMEUNIT.MINUTE;
                break;
            }
            case H: 
            case HOUR: 
            case HOURS: {
                result = TIMEUNIT.HOUR;
                break;
            }
            case D: 
            case DAY: 
            case DAYS: {
                result = TIMEUNIT.DAY;
                break;
            }
            case MON: 
            case MONS: 
            case MONTH: 
            case MONTHS: {
                result = TIMEUNIT.MONTH;
                break;
            }
            case Y: 
            case YEAR: 
            case YEARS: {
                result = TIMEUNIT.YEAR;
            }
        }
        return result;
    }

    public TimeInterval(int quantity, TIMEUNIT timeUnit) {
        this.timeQty = quantity;
        this.timeUnit = timeUnit;
    }

    public long getSeconds() {
        long result = 0L;
        switch (this.timeUnit) {
            case SECONDS: 
            case SECOND: 
            case S: 
            case SECS: {
                result = this.timeQty;
                break;
            }
            case MIN: 
            case M: 
            case MINS: 
            case MINUTE: 
            case MINUTES: {
                result = this.timeQty * 60;
                break;
            }
            case H: 
            case HOUR: 
            case HOURS: {
                result = this.timeQty * 60 * 60;
                break;
            }
            case D: 
            case DAY: 
            case DAYS: {
                result = this.timeQty * 60 * 60 * 24;
                break;
            }
            case MON: 
            case MONS: 
            case MONTH: 
            case MONTHS: {
                result = this.timeQty * 60 * 60 * 24 * 30;
                break;
            }
            case Y: 
            case YEAR: 
            case YEARS: {
                result = this.timeQty * 60 * 60 * 24 * 365;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    public TIMEUNIT getTimeUnit() {
        return this.timeUnit;
    }

    public int getQuantity() {
        return this.timeQty;
    }

    public static TimeInterval parse(String timeIntervalString) {
        Matcher matcher = timeIntervalPattern.matcher(timeIntervalString);
        assert (matcher.groupCount() == 2);
        matcher.find();
        int timeQty = Integer.parseInt(matcher.group(1));
        TIMEUNIT timeUnit = TimeInterval.getTimeUnit(matcher.group(2));
        return new TimeInterval(timeQty, timeUnit);
    }

    public String toString() {
        return this.timeQty + this.timeUnit.toString();
    }

    public static long snapToYear(long timestamp) {
        return DateUtils.truncate((Date)new Date(timestamp), (int)1).getTime();
    }

    public static long snapToMonth(long timestamp) {
        return DateUtils.truncate((Date)new Date(timestamp), (int)2).getTime();
    }

    public static long snapToDay(long timestamp) {
        return DateUtils.truncate((Date)new Date(timestamp), (int)5).getTime();
    }

    public static long snapToHour(long timestamp) {
        return DateUtils.truncate((Date)new Date(timestamp), (int)11).getTime();
    }

    public static long snapToMinute(long timestamp) {
        return DateUtils.truncate((Date)new Date(timestamp), (int)12).getTime();
    }

    public static long snapToFiveMinutes(long timestamp) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(new Date(timestamp));
        int unroundedMinutes = calendar.get(12);
        int mod = unroundedMinutes % 5;
        calendar.add(12, -mod);
        return DateUtils.truncate((Date)calendar.getTime(), (int)12).getTime();
    }

    public static enum TIMEUNIT {
        YEAR,
        YEARS,
        Y,
        MONTH,
        MONTHS,
        MON,
        MONS,
        DAY,
        DAYS,
        D,
        HOUR,
        HOURS,
        H,
        MINUTE,
        MINUTES,
        MIN,
        MINS,
        M,
        SECOND,
        SECONDS,
        SECS,
        S;

    }
}

