/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import com.splunk.df.util.IndexSpecifier;
import com.splunk.df.util.IndexSpecifierMeta;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class EstimatedEventCount {
    static final Logger logger = Logger.getLogger(EstimatedEventCount.class);
    private IndexSpecifier.IndexSpecifierVector[] indexSpecifierVectors = new IndexSpecifier.IndexSpecifierVector[0];
    private IndexSpecifierMeta[] indexSpecifierMetaVector = new IndexSpecifierMeta[0];

    public EstimatedEventCount(JSONArray array) {
        this.indexSpecifierVectors = new IndexSpecifier.IndexSpecifierVector[array.length()];
        this.indexSpecifierMetaVector = new IndexSpecifierMeta[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            this.indexSpecifierVectors[i] = EstimatedEventCount.loadIndexSpecifierVector(array.getJSONObject(i));
            this.indexSpecifierMetaVector[i] = EstimatedEventCount.loadIndexSpecifierMeta(array.getJSONObject(i));
        }
        logger.info((Object)String.format("number of elements in index metadata: %d", array.length()));
    }

    public int getSplunkServerCount() {
        int count = 0;
        for (int i = 0; i < this.indexSpecifierMetaVector.length; ++i) {
            IndexSpecifierMeta ismv = this.indexSpecifierMetaVector[i];
            if (ismv == null) continue;
            count += ismv.getBucketMetaArray().array().length;
        }
        logger.info((Object)String.format("bucket server count: %d", count));
        count = Math.max(count, 1);
        return count;
    }

    public String toString() {
        String output = "";
        for (int i = 0; i < this.indexSpecifierVectors.length; ++i) {
            if (this.indexSpecifierVectors[i] != null) {
                output = output + this.indexSpecifierVectors[i].toString();
            }
            if (this.indexSpecifierMetaVector[i] == null) continue;
            output = output + this.indexSpecifierMetaVector[i].toString();
        }
        return output;
    }

    public long getTotalEventCount() {
        long totalEventCount = 0L;
        for (int i = 0; i < this.indexSpecifierMetaVector.length; ++i) {
            if (this.indexSpecifierMetaVector[i] == null) continue;
            totalEventCount += this.indexSpecifierMetaVector[i].getTotalEventCount().longValue();
        }
        return totalEventCount;
    }

    private static IndexSpecifier.IndexSpecifierVector loadIndexSpecifierVector(JSONObject json) {
        if (!json.has("ssc")) {
            return null;
        }
        JSONArray array = json.getJSONArray("ssc");
        if (array.length() == 0) {
            return null;
        }
        IndexSpecifier.IndexSpecifierVector indexSpecifierVector = new IndexSpecifier().new IndexSpecifier.IndexSpecifierVector();
        for (int i = 0; i < array.length(); ++i) {
            indexSpecifierVector.and(EstimatedEventCount.loadIndexSpecifier(array.getJSONObject(i)));
        }
        return indexSpecifierVector;
    }

    private static IndexSpecifier loadIndexSpecifier(JSONObject json) {
        return new IndexSpecifier(json.getString("index_name"), json.getString("index_type"), json.getString("earliest"), json.getString("latest"));
    }

    private static IndexSpecifierMeta loadIndexSpecifierMeta(JSONObject ec) {
        if (!ec.has("ec")) {
            return null;
        }
        JSONObject json = ec.getJSONObject("ec");
        if (!(json.has("search") && json.has("bucketMeta") && json.has("totalEventCount"))) {
            return null;
        }
        return new IndexSpecifierMeta(json.getString("search"), EstimatedEventCount.loadBucketMetaArray(json.getJSONArray("bucketMeta")), json.getNumber("totalEventCount"));
    }

    private static IndexSpecifierMeta.BucketMeta.BucketMetaArray loadBucketMetaArray(JSONArray array) {
        IndexSpecifierMeta.BucketMeta.BucketMetaArray bucketMetaArray = new IndexSpecifierMeta().new IndexSpecifierMeta.BucketMeta().new IndexSpecifierMeta.BucketMeta.BucketMetaArray();
        for (int i = 0; i < array.length(); ++i) {
            bucketMetaArray.and(EstimatedEventCount.loadBucketMeta(array.getJSONObject(i)));
        }
        logger.info((Object)String.format("size of bucket meta array: %d", array.length()));
        return bucketMetaArray;
    }

    private static String[] loadBucketId(JSONObject json) {
        ArrayList<String> buckets = new ArrayList<String>();
        if (!json.has("bucketId")) {
            return buckets.toArray(new String[0]);
        }
        JSONObject bucketIdJson = json.getJSONObject("bucketId");
        if (bucketIdJson.getString("type").equals("multivalue")) {
            JSONArray array = bucketIdJson.getJSONArray("value");
            for (int i = 0; i < array.length(); ++i) {
                buckets.add(array.getString(i));
            }
        } else {
            buckets.add(bucketIdJson.getString("value"));
        }
        return buckets.toArray(new String[buckets.size()]);
    }

    private static Number[] loadBucketCount(JSONObject json) {
        ArrayList<Number> counts = new ArrayList<Number>();
        if (!json.has("eventCount")) {
            return counts.toArray(new Number[0]);
        }
        JSONObject countsJson = json.getJSONObject("eventCount");
        if (countsJson.getString("type").equals("multivalue")) {
            JSONArray array = countsJson.getJSONArray("value");
            for (int i = 0; i < array.length(); ++i) {
                counts.add(array.getNumber(i));
            }
        } else {
            counts.add(countsJson.getNumber("value"));
        }
        return counts.toArray(new Number[counts.size()]);
    }

    private static IndexSpecifierMeta.BucketMeta loadBucketMeta(JSONObject json) {
        IndexSpecifierMeta indexSpecifierMeta = new IndexSpecifierMeta();
        indexSpecifierMeta.getClass();
        return indexSpecifierMeta.new IndexSpecifierMeta.BucketMeta(json.getJSONObject("index").getString("value"), json.getJSONObject("splunk_server").getString("value"), EstimatedEventCount.loadBucketId(json), EstimatedEventCount.loadBucketCount(json), json.getJSONObject("count").getNumber("value"));
    }
}

