/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.serdes.fieldCompressed;

import com.splunk.df.serdes.fieldCompressed.FastSplunkEventChunk;
import com.splunk.df.serdes.fieldCompressed.util.DataUtil;
import com.splunk.df.serdes.fieldCompressed.util.EncodingStringCache;
import com.splunk.df.serdes.fieldCompressed.util.ReadableThresholdStringCache;
import com.splunk.df.serdes.fieldCompressed.util.Writable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FastSplunkEvent
implements Writable {
    public static final int HAS_TIME = 2;
    public static final int HAS_SUBSECONDS = 4;
    long time = -1L;
    long encodedSubseconds = -1L;
    FastSplunkEventChunk chunk;
    List<String> fields = new ArrayList<String>();

    static FastSplunkEvent read(FastSplunkEventChunk chunk, InputStream in, ReadableThresholdStringCache cache) throws IOException {
        FastSplunkEvent retrieved = chunk.createEvent();
        long flags = DataUtil.readBase128(in);
        if ((flags & 2L) > 0L) {
            retrieved.time = DataUtil.readBase128(in);
        }
        if ((flags & 4L) > 0L) {
            retrieved.encodedSubseconds = DataUtil.readBase128(in);
        }
        DataUtil.readStringList(retrieved.fields, in, cache);
        return retrieved;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getEncodedSubseconds() {
        return this.encodedSubseconds;
    }

    public void setEncodedSubseconds(long encodedSubseconds) {
        this.encodedSubseconds = encodedSubseconds;
    }

    public void addField(String value) {
        this.fields.add(value);
    }

    public void addField(String name, String value) {
        Integer pos = this.chunk.fieldNameToPosition.get(name);
        if (null == pos) {
            this.chunk.header.add(name);
            pos = this.chunk.header.size() - 1;
            this.chunk.fieldNameToPosition.put(name, pos);
        }
        for (int i = this.fields.size(); i < pos; ++i) {
            this.fields.add(null);
        }
        this.fields.add(pos, value);
    }

    public int size() {
        return this.fields.size();
    }

    public String getField(String name) {
        Integer pos = this.chunk.fieldNameToPosition.get(name);
        return null == pos ? null : this.fields.get(pos);
    }

    public String getField(int pos) {
        return this.fields.get(pos);
    }

    @Override
    public byte getType() {
        return 0;
    }

    public void write(OutputStream out, EncodingStringCache cache) throws IOException {
        int flags;
        out.write(this.getType());
        int n = flags = this.time > 0L ? 2 : 0;
        if (this.encodedSubseconds > 0L) {
            flags |= 4;
        }
        DataUtil.writeBase128(out, flags);
        if (this.time > 0L) {
            DataUtil.writeBase128(out, this.time);
        }
        if (this.encodedSubseconds > 0L) {
            DataUtil.writeBase128(out, this.encodedSubseconds);
        }
        DataUtil.writeStringList(this.fields, out, cache);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FastSplunkEvent)) {
            return false;
        }
        FastSplunkEvent other = (FastSplunkEvent)obj;
        if (this.time != other.time || this.encodedSubseconds != other.encodedSubseconds) {
            return false;
        }
        return this.fields.equals(other.fields);
    }
}

