/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import java.util.ArrayList;
import java.util.List;

public class ListAggregateValue
extends BaseAggregateValue {
    private List<String> valuesList = new ArrayList<String>();
    private int maxLimit;

    public ListAggregateValue(int maxLimit) {
        this.maxLimit = maxLimit;
    }

    @Override
    public Object getValue() {
        return this.valuesList;
    }

    @Override
    public AggregateValue accumulate(Object value) {
        assert (value instanceof List);
        this.accumulateToLimit((List)value);
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof ListAggregateValue);
        this.accumulateToLimit((List)aggregateValue.getValue());
        return this;
    }

    private void accumulateToLimit(List listToAdd) {
        int currSize = this.valuesList.size();
        if (currSize < this.maxLimit && listToAdd != null) {
            int listIndex = Math.min(this.maxLimit - currSize, listToAdd.size());
            this.valuesList.addAll(listToAdd.subList(0, listIndex));
        }
    }

    public void setMaxLimit(int maxLimit) {
        this.maxLimit = maxLimit;
    }
}

