/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.spark;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.compute.ComputeEngine;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.spark.SparkComputeEngineConstants;
import com.splunk.df.search.compute.spark.SparkDistributedDataset;
import com.splunk.df.search.compute.spark.SparkExecutionHints;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;

public class SparkComputeEngine
implements ComputeEngine,
SparkComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SparkComputeEngine.class);
    private JavaSparkContext jsc;
    private ComputeEngineContext ctx;

    private static void registerTransformers(ComputeEngineContext ctx) {
        TransformerRegistry tr = (TransformerRegistry)ctx.get("dfs.dataset.transformer.registry");
        if (tr == null) {
            tr = new TransformerRegistry();
            ctx.addContext("dfs.dataset.transformer.registry", tr);
        }
        tr.registerTransformer("stats", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.StatsTransformer"));
        tr.registerTransformer("sort", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.SortTransformer"));
        tr.registerTransformer("head", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.HeadTransformer"));
        tr.registerTransformer("join", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.JoinTransformer"));
        tr.registerTransformer("fields", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.FieldsTransformer"));
        tr.registerTransformer("reverse", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.ReverseTransformer"));
        tr.registerTransformer("table", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.TableTransformer"));
        tr.registerTransformer("tail", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.TailTransformer"));
        tr.registerTransformer("unknown", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.ExternalTransformerImpl"));
        tr.registerTransformer("union", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.UnionTransformer"));
        tr.registerTransformer("dedup", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.DedupTransformer"));
        tr.registerTransformer("noop", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.NoopTransformer"));
        tr.registerTransformer("rename", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.RenameTransformer"));
        tr.registerTransformer("where", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.WhereTransformer"));
        tr.registerTransformer("eval", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.EvalTransformer"));
    }

    private static Transformer createTransformer(ComputeEngineContext ctx, String clazz) {
        try {
            Transformer transformer = (Transformer)Class.forName(clazz).newInstance();
            logger.debug((Object)("Created transformer: " + clazz));
            return transformer;
        }
        catch (Throwable t) {
            logger.error((Object)("Could not create trasformer: " + clazz), t);
            throw new RuntimeException("could not create distributed dataset transformer", t);
        }
    }

    @Override
    public void close() {
        logger.debug((Object)"Closing spark compute engine");
        this.jsc.close();
    }

    @Override
    public DistributedDataset executeBatchSearch(DistributedDataset dd, CommandNode query) {
        String cmdName = query.getCommandName();
        logger.debug((Object)("Executing batch search with starting command name: " + cmdName));
        Transformer t = ((TransformerRegistry)this.ctx.get("dfs.dataset.transformer.registry")).getTransformer(query);
        if (t == null) {
            logger.error((Object)("Could not find transformer for command: " + cmdName));
            throw new RuntimeException("could not find transformer for command: " + cmdName);
        }
        logger.debug((Object)("Found transformer: " + t.name()));
        dd = t.transform(dd, query, true, this.ctx);
        return dd;
    }

    @Override
    public void setContext(ComputeEngineContext ctx) {
        this.ctx = ctx;
        int dfcExecutorMemMbs = (Integer)ctx.get("executor.memory.mbs");
        int dfcDriverMemMbs = (Integer)ctx.get("driver.memory.mbs");
        int numCores = (Integer)ctx.get("numCores");
        int coresPerExecutor = (Integer)ctx.get("cores.per.executor");
        long maxReducePartitionSize = (Long)ctx.getOrDefault("MAX_REDUCE_PARTITION_SIZE", 500000L);
        SparkExecutionHints seh = new SparkExecutionHints(dfcExecutorMemMbs, dfcDriverMemMbs, numCores, coresPerExecutor, maxReducePartitionSize);
        ctx.addContext("execution.hints", seh);
        this.jsc = (JavaSparkContext)ctx.get("java.spark.context");
        SparkComputeEngine.checkVersion(this.jsc);
        SparkComputeEngine.registerTransformers(ctx);
        logger.debug((Object)"Registered all transformers");
    }

    private static void registerExecutionListener(SparkContext sc) {
        sc.addSparkListener((SparkListenerInterface)new SparkListener(){

            public void onApplicationEnd(SparkListenerApplicationEnd event) {
            }

            public void onApplicationStart(SparkListenerApplicationStart event) {
            }

            public void onBlockManagerAdded(SparkListenerBlockManagerAdded event) {
            }

            public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved event) {
            }

            public void onBlockUpdated(SparkListenerBlockUpdated event) {
            }

            public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate event) {
            }

            public void onExecutorAdded(SparkListenerExecutorAdded event) {
            }

            public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate event) {
            }

            public void onExecutorRemoved(SparkListenerExecutorRemoved event) {
            }

            public void onJobEnd(SparkListenerJobEnd event) {
                logger.debug((Object)String.format("Spark job ended: id: %d, details: %s", event.jobId(), event.toString()));
            }

            public void onJobStart(SparkListenerJobStart event) {
                logger.debug((Object)String.format("Spark job started: id: %d, details: %s", event.jobId(), event.toString()));
            }

            public void onStageCompleted(SparkListenerStageCompleted event) {
                logger.debug((Object)String.format("Spark job stage completed: stage id: %d, stage name: %s, num tasks: %d, status: %s", event.stageInfo().stageId(), event.stageInfo().name(), event.stageInfo().numTasks(), event.stageInfo().getStatusString()));
            }

            public void onStageSubmitted(SparkListenerStageSubmitted event) {
                logger.debug((Object)String.format("Spark job stage submitted: stage id: %d, stage name: %s, num tasks: %d, properties: %s, stage info details: \nTHIS IS NOT AN ERROR, IT IS A STACK TRACE OF THE DAG-NODE BEING EXECUTED AS PART OF THIS STAGE!!!!! >>>>>\n%s\n<<<<<", event.stageInfo().stageId(), event.stageInfo().name(), event.stageInfo().numTasks(), event.properties().toString(), event.stageInfo().details()));
            }

            public void onTaskEnd(SparkListenerTaskEnd event) {
            }

            public void onTaskGettingResult(SparkListenerTaskGettingResult event) {
            }

            public void onTaskStart(SparkListenerTaskStart event) {
            }

            public void onUnpersistRDD(SparkListenerUnpersistRDD event) {
            }
        });
    }

    private static void checkVersion(JavaSparkContext ctx) {
        String version = ctx.version();
        for (int i = 0; i < supportedVersions.length; ++i) {
            String ver = supportedVersions[i];
            if (!ver.trim().equalsIgnoreCase(version)) continue;
            return;
        }
        throw new RuntimeException(String.format("Unsupported spark core version: %s", version));
    }

    @Override
    public DistributedDataset emptyDataset() {
        return new SparkDistributedDataset(this.ctx, this.jsc);
    }

    @Override
    public DistributedDataset executeBatchSearch(CommandNode query) {
        logger.info((Object)String.format("Spark compute engine: executing batch search with query: %s", query.accept((NodeVisitor)new SplFormatter())));
        SparkDistributedDataset dd = new SparkDistributedDataset(this.ctx, this.jsc);
        return this.executeBatchSearch(dd, query);
    }

    public void finalize() {
        logger.debug((Object)String.format("Compute engine objct is destroyed", new Object[0]));
    }

    @Override
    public boolean isClosed() {
        return this.jsc.sc().isStopped();
    }
}

