/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.search.HostPort;
import com.splunk.df.search.SplunkEventChunk;
import com.splunk.df.search.SplunkEventReceiverManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.broadcast.Broadcast;

@Deprecated
public class SparkUtils {
    static final Logger logger = Logger.getLogger(SparkUtils.class);

    public static JavaRDD<HostPort> createReceivers(JavaSparkContext sc, final int startPort, int numReceivers, String uuid) {
        ArrayList<String> dummies = new ArrayList<String>();
        for (int i = 0; i < numReceivers; ++i) {
            dummies.add("dummy" + i);
        }
        JavaRDD dummyRdd = sc.parallelize(dummies, dummies.size());
        final Broadcast uuidBc = sc.broadcast((Object)uuid);
        JavaRDD receivers = dummyRdd.map((Function)new Function<String, HostPort>(){
            private static final long serialVersionUID = 1L;

            public HostPort call(String dummy) throws Exception {
                int port = startPort;
                while (true) {
                    try {
                        ServerSocket ss = new ServerSocket(port);
                        logger.info((Object)("Successfully bound to port: " + port));
                        SplunkEventReceiverManager.getInstance().addListener((String)uuidBc.getValue(), ss);
                        logger.info((Object)("Receiver added to the receiver pool with uuid: " + (String)uuidBc.getValue() + " on port: " + port));
                    }
                    catch (IOException ie) {
                        ++port;
                        continue;
                    }
                    break;
                }
                String host = System.getenv("SPLUNK_HOSTNAME");
                int boundPort = port;
                logger.info((Object)("Receiver started on host: " + host + "; port: " + boundPort));
                return new HostPort(host, boundPort);
            }
        });
        return receivers;
    }

    public static JavaRDD<SplunkEventChunk> createEventingRdd(JavaRDD<HostPort> receivers, final String uuid, final int numChunks) {
        JavaRDD chunksRdd = receivers.flatMap((FlatMapFunction)new FlatMapFunction<HostPort, SplunkEventChunk>(){

            public Iterator<SplunkEventChunk> call(HostPort receiver) throws Exception {
                String host = System.getenv("SPLUNK_HOSTNAME");
                logger.debug((Object)("Current host: " + host + ", receiver host: " + receiver.getHost()));
                return new Iterator<SplunkEventChunk>(){
                    SplunkEventChunk chunk = null;
                    int chunksReturned = 0;

                    @Override
                    public boolean hasNext() {
                        if (this.chunksReturned >= numChunks) {
                            logger.debug((Object)("returned " + this.chunksReturned + " in one batch"));
                            return false;
                        }
                        if (this.chunk != null) {
                            return true;
                        }
                        try {
                            this.chunk = SplunkEventReceiverManager.getInstance().getNextEventChunk(uuid);
                        }
                        catch (InterruptedException ie) {
                            logger.error((Object)("Error while getting event chunk: " + ie.getMessage()));
                            return false;
                        }
                        if (this.chunk != null) {
                            return true;
                        }
                        logger.debug((Object)"No more chunks found in cache");
                        logger.debug((Object)("Returned " + this.chunksReturned + " in one batch"));
                        return false;
                    }

                    @Override
                    public SplunkEventChunk next() {
                        logger.debug((Object)("Returning chunk to spark: " + this.chunk));
                        SplunkEventChunk ret = this.chunk;
                        ++this.chunksReturned;
                        this.chunk = null;
                        return ret;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        });
        return chunksRdd;
    }

    public static void shutdownReceivers(JavaRDD<HostPort> receivers, final String uuid) {
        receivers.foreach((VoidFunction)new VoidFunction<HostPort>(){
            private static final long serialVersionUID = 1L;

            public void call(HostPort receiver) throws Exception {
                SplunkEventReceiverManager.getInstance().stopReceiver(uuid, receiver.getPort());
                logger.debug((Object)("Stopped receiver: " + receiver));
            }
        });
        receivers.unpersist();
    }
}

