/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.search.HostPort;
import com.splunk.df.search.SplunkEvent;
import com.splunk.df.search.SplunkEventChunk;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class ParallelExportProcessor {
    static Logger logger = null;
    private static ScheduledExecutorService ses = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private LinkedBlockingDeque<SplunkEvent> eventCache = new LinkedBlockingDeque(10000);
    private LinkedBlockingDeque<SplunkEventChunk> chunkCache = new LinkedBlockingDeque(10);
    private boolean finished = false;
    private String hostName = Utils.getIpFromSplunkHostnameEnv();
    private long fromSplunkd = 0L;
    private String infoCsvContent;
    private String sparkLookupCode;

    public ParallelExportProcessor(BufferedReader br, BufferedWriter bw) throws IOException, JSONException, InterruptedException {
        try {
            long waitTimeFromSplunkd = 0L;
            boolean eventing = true;
            while (true) {
                if (!br.ready()) {
                    long s = System.currentTimeMillis();
                    Thread.sleep(100L);
                    waitTimeFromSplunkd += System.currentTimeMillis() - s;
                    continue;
                }
                logger.debug((Object)"About to read line");
                String headerLine = br.readLine();
                logger.debug((Object)("Read line: " + headerLine));
                String[] headers = headerLine.split(" |,");
                int actionLen = Integer.valueOf(headers[2]);
                int dataLen = Integer.valueOf(headers[3]);
                logger.debug((Object)("Read header line: " + headerLine + "; action length: " + actionLen + "; data length: " + dataLen));
                String actionStr = null;
                if (actionLen > 0) {
                    char[] actionBuff = new char[actionLen];
                    br.read(actionBuff, 0, actionLen);
                    actionStr = new String(actionBuff);
                    logger.debug((Object)("Received action string: " + actionStr));
                }
                String dataStr = null;
                char[] dataBuff = new char[dataLen];
                int read = 0;
                if (dataLen > 0) {
                    do {
                        int ret;
                        if ((ret = br.read(dataBuff, read, dataBuff.length - read)) >= 0) {
                            read += ret;
                        }
                        if (ret < 0 && read < dataLen) {
                            logger.error((Object)"End of buffer reached but not all events could be read");
                            throw new RuntimeException("could not read all the events from splunkd");
                        }
                        logger.debug((Object)("Ret: " + ret + ", read: " + read + ", remaining: " + (dataBuff.length - read)));
                    } while (dataLen > read);
                    dataStr = new String(dataBuff);
                }
                if (actionStr != null) {
                    JSONObject actionObj = new JSONObject(actionStr);
                    if (!actionObj.has("action")) continue;
                    String action = actionObj.getString("action");
                    if (action.equals("getinfo")) {
                        JSONObject sri = actionObj.getJSONObject("searchinfo");
                        String dispatchDir = sri.getString("dispatch_dir");
                        logger.debug((Object)("Search dispatch directory in splunkd: " + dispatchDir));
                        String infoCsvFile = dispatchDir + "/info.csv";
                        this.infoCsvContent = new String(Files.readAllBytes(Paths.get(infoCsvFile, new String[0])));
                        this.sparkLookupCode = this.getSparkLookupCode(this.infoCsvContent);
                        logger.error((Object)("sparkLookupCode: " + this.sparkLookupCode));
                        JSONArray args = sri.getJSONArray("args");
                        String mode = (String)args.get(0);
                        logger.debug((Object)("Mode: " + mode));
                        if (!mode.startsWith("eventing")) {
                            eventing = false;
                            logger.debug((Object)"Mode set to non eventing search; hence events will not be forwarded in time order");
                        } else {
                            logger.debug((Object)"Events will get forwarded in time order");
                        }
                        ArrayList<String> hostPortsRaw = new ArrayList<String>();
                        for (int i = 1; i < args.length(); ++i) {
                            String hostPort = args.getString(i);
                            hostPortsRaw.add(hostPort);
                        }
                        logger.debug((Object)("received host port string: " + hostPortsRaw));
                        List<HostPort> hostPorts = this.getHostPorts(hostPortsRaw);
                        logger.error((Object)("About to create receivers: " + hostPorts));
                        this.startEventDispatchers(hostPorts, eventing);
                        String actionResponse = "{\"type\":\"streaming\"}";
                        String responseHeader = "chunked 1.0," + actionResponse.length() + ",0";
                        bw.write(responseHeader + "\n");
                        bw.write(actionResponse);
                        bw.flush();
                        logger.debug((Object)"Processed get info action");
                        continue;
                    }
                    if (action.equals("execute")) {
                        boolean lastChunk = actionObj.getBoolean("finished");
                        BufferedReader dbr = new BufferedReader(new StringReader(dataStr));
                        dataStr = null;
                        this.performExecute(bw, dbr, lastChunk, eventing, this.infoCsvContent, this.sparkLookupCode);
                        if (!lastChunk) continue;
                        break;
                    }
                    throw new RuntimeException("unrecognized action string: " + actionStr);
                }
                if (dataStr == null) continue;
                BufferedReader dbr = new BufferedReader(new StringReader(dataStr));
                dataStr = null;
                this.performExecute(bw, dbr, false, eventing, this.infoCsvContent, this.sparkLookupCode);
            }
            logger.debug((Object)"Breaking since last chunk processed");
            logger.info((Object)("Completed posting all events to cache - now waiting for cache to be dispatched; total wait time for receiving events from splund: " + waitTimeFromSplunkd + " millis"));
        }
        catch (Throwable t) {
            logger.error((Object)"Exception received while forwarding events to spark", t);
            throw t;
        }
    }

    public static void main(String[] args) {
        try {
            long start = System.currentTimeMillis();
            logger.info((Object)"Parallel export processor started =======================");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(System.out));
            new ParallelExportProcessor(br, bw);
            long elapsed = System.currentTimeMillis() - start;
            logger.info((Object)("==================== exported events/chunks; time taken: " + elapsed + " millis"));
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to process events for sending to spark", t);
            System.exit(-1);
        }
    }

    private String getSparkLookupCode(String infoCsvContent) throws IOException {
        StringReader sr = new StringReader(infoCsvContent);
        CSVParser parser = new CSVParser((Reader)sr, CSVFormat.DEFAULT);
        Iterator recs = parser.iterator();
        CSVRecord infoMetadata = (CSVRecord)recs.next();
        int index = -1;
        int infoMetadataSize = infoMetadata.size();
        for (int i = 0; i < infoMetadataSize; ++i) {
            String infoMetadataStr = infoMetadata.get(i);
            if (!infoMetadataStr.equals("sparkLookupCode")) continue;
            index = i;
            break;
        }
        String sparkLookupCode = this.hostName;
        if (index >= 0) {
            CSVRecord infoData = (CSVRecord)recs.next();
            sparkLookupCode = infoData.get(index);
            logger.debug((Object)("Found sparkLookupCode inside infocsv content: " + sparkLookupCode));
        }
        parser.close();
        return sparkLookupCode;
    }

    private List<HostPort> getHostPorts(List<String> hostPortsRaw) throws JSONException {
        ArrayList<HostPort> hostPortsList = new ArrayList<HostPort>();
        for (int i = 0; i < hostPortsRaw.size(); ++i) {
            String hostPortStr = hostPortsRaw.get(i);
            String[] split = hostPortStr.split(":");
            String host = split[0];
            int port = Integer.valueOf(split[1]);
            HostPort hostPort = new HostPort(host, port);
            hostPortsList.add(hostPort);
        }
        return hostPortsList;
    }

    private void startEventDispatchers(List<HostPort> hostPorts, final boolean eventing) {
        Iterator<HostPort> hpi = hostPorts.iterator();
        int hash = this.hostName.hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        int idx = hash % hostPorts.size();
        logger.info((Object)("Receiver index for chunk forwarding: " + idx + ", hash : " + hash + ", hostPorts.size(): " + hostPorts.size()));
        int i = 0;
        while (hpi.hasNext()) {
            final HostPort hp = hpi.next();
            if (eventing && i == idx || !eventing) {
                logger.debug((Object)("++++++++++++++++++++++ will forward events to receiver: " + hp));
                ses.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Socket s = null;
                        BufferedWriter bw = null;
                        long[] times = new long[1];
                        try {
                            logger.debug((Object)("****** ################### about to open socket for: " + hp));
                            s = new Socket(hp.getHost(), hp.getPort());
                            logger.debug((Object)("*********** successfully connected to: " + hp));
                            bw = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
                            boolean ret = false;
                            do {
                                if (eventing) {
                                    ret = ParallelExportProcessor.this.processChunks(bw, times);
                                    continue;
                                }
                                ParallelExportProcessor.this.processEvents(bw, times, ParallelExportProcessor.this.infoCsvContent, ParallelExportProcessor.this.sparkLookupCode);
                            } while (!ret);
                            logger.debug((Object)("################## total time taken to actually dispatch events: " + times[0]));
                            logger.debug((Object)"No more events in cache and forwarder is finsihed reading all events");
                        }
                        catch (Throwable t) {
                            logger.error((Object)("Error while sending events to spark using hostPort: " + hp), t);
                        }
                        finally {
                            try {
                                if (bw != null) {
                                    bw.close();
                                }
                            }
                            catch (Throwable t) {
                                logger.error((Object)"Error while closing socket buffered reader", t);
                            }
                            try {
                                if (s != null) {
                                    s.close();
                                }
                            }
                            catch (Throwable t) {
                                logger.error((Object)"Error while closing socket", t);
                            }
                        }
                    }
                }, 0L, TimeUnit.SECONDS);
            }
            ++i;
        }
    }

    private boolean processEvents(BufferedWriter bw, long[] times, String infoCsvContent, String sparkLookupCode) throws IOException, InterruptedException {
        SplunkEvent event;
        long totalTime = times[0];
        if (this.eventCache.isEmpty()) {
            if (this.finished) {
                logger.info((Object)"Event cache is empty and all events have been grabbed from splunkd, hence dispatch is compeleted");
                bw.write("<EOF>\n");
                bw.flush();
                return true;
            }
            try {
                Thread.sleep(100L);
                return false;
            }
            catch (Throwable t) {
                logger.error((Object)"Error while sleeping");
            }
        }
        long start = System.currentTimeMillis();
        ArrayList<SplunkEvent> events = new ArrayList<SplunkEvent>();
        while ((event = this.eventCache.poll(100L, TimeUnit.MILLISECONDS)) != null) {
            events.add(event);
        }
        SplunkEventChunk chunk = this.createChunk(events, infoCsvContent, sparkLookupCode, this.finished);
        this.sendChunk(bw, chunk, times);
        logger.info((Object)("++++++++++++++++++++++ sent " + events.size() + " events to spark from thread: " + Thread.currentThread().getId()));
        long elapsed = System.currentTimeMillis() - start;
        times[0] = totalTime += elapsed;
        return false;
    }

    private SplunkEventChunk createChunk(List<SplunkEvent> events, String infoCsvContent, String sparkLookupCode, boolean lastChunk) throws IOException {
        StringBuilder data = new StringBuilder();
        String host = this.hostName;
        long startTime = -1L;
        long endTime = -1L;
        int numEvents = events.size();
        Iterator<SplunkEvent> ei = events.iterator();
        boolean firstEvent = true;
        while (ei.hasNext()) {
            SplunkEvent event = ei.next();
            if (firstEvent) {
                String metadata = event.getMetadata();
                data.append(metadata + "\n");
                firstEvent = false;
            }
            event.getData(data);
            data.append("\n");
            long time = event.getTime();
            if (startTime >= time) {
                startTime = time;
            }
            if (endTime > time) continue;
            endTime = time;
        }
        String compressed = Utils.compressAndEncode(data.toString());
        SplunkEventChunk chunk = new SplunkEventChunk(host, startTime, endTime, compressed, numEvents, Utils.compressAndEncode(infoCsvContent), sparkLookupCode, lastChunk);
        return chunk;
    }

    private boolean processChunks(BufferedWriter bw, long[] times) throws IOException, InterruptedException {
        SplunkEventChunk chunk2;
        long totalTime = times[0];
        if (this.chunkCache.isEmpty()) {
            if (this.finished) {
                logger.info((Object)"Chunk cache is empty and all chunks have been grabbed from splunkd, hence dispatch is compeleted");
                bw.write("<EOF>\n");
                bw.flush();
                return true;
            }
            try {
                Thread.sleep(100L);
                return false;
            }
            catch (Throwable t) {
                logger.error((Object)"Error while sleeping");
            }
        }
        long start = System.currentTimeMillis();
        ArrayList<SplunkEventChunk> chunks = new ArrayList<SplunkEventChunk>();
        while ((chunk2 = this.chunkCache.poll(100L, TimeUnit.MILLISECONDS)) != null) {
            chunks.add(chunk2);
            logger.debug((Object)("+++++++++ added chunk to deliver to receivers: " + chunk2));
        }
        for (SplunkEventChunk chunk2 : chunks) {
            this.sendChunk(bw, chunk2, times);
        }
        long elapsed = System.currentTimeMillis() - start;
        times[0] = totalTime += elapsed;
        return false;
    }

    private void sendChunk(BufferedWriter bw, SplunkEventChunk chunk, long[] times) throws IOException {
        long totalTime = times[0];
        long start = System.currentTimeMillis();
        String header = "\"" + this.hostName + "\",\"" + chunk.getStartTime() + "\",\"" + chunk.getEndTime() + "\",\"" + chunk.getNumEvents() + "\",\"" + chunk.isLastChunk() + "\"";
        StringWriter sw = new StringWriter();
        sw.write(header + "\n");
        sw.write(chunk.getSparkLookupCode() + "\n");
        sw.write(chunk.getCompressedInfoCsv() + "\n");
        sw.write(chunk.getCompressedData() + "\n");
        bw.write(sw.toString());
        bw.flush();
        long elapsed = System.currentTimeMillis() - start;
        logger.info((Object)("++++++++++++++++++++++ sent " + chunk + " from thread: " + Thread.currentThread().getId() + "; time taken: " + elapsed + " millis"));
        times[0] = totalTime += elapsed;
    }

    private void performExecute(BufferedWriter bw, BufferedReader dbr, boolean lastChunk, boolean eventing, String infoCsvContent, String sparkLookupCode) throws IOException {
        long start = System.currentTimeMillis();
        logger.info((Object)("Reading events out of data string with eventing: " + eventing));
        CSVParser parser = new CSVParser((Reader)dbr, CSVFormat.DEFAULT);
        Iterator recs = parser.iterator();
        CSVRecord metadata = (CSVRecord)recs.next();
        logger.info((Object)("Read metadata record: " + metadata));
        StringBuilder chunkData = new StringBuilder();
        if (eventing) {
            Utils.appendCSVRecord(chunkData, metadata);
        }
        int eventCount = 0;
        long startTime = -1L;
        boolean first = true;
        long timeToParse = 0L;
        CSVRecord lastRec = null;
        while (recs.hasNext()) {
            SplunkEvent event;
            long s1 = System.currentTimeMillis();
            timeToParse += System.currentTimeMillis() - s1;
            CSVRecord rec = (CSVRecord)recs.next();
            if (eventing) {
                if (first) {
                    long time;
                    event = new SplunkEvent(metadata, rec);
                    String timeStr = (String)event.get("_time");
                    startTime = time = Float.valueOf(timeStr).longValue();
                    logger.debug((Object)("Start time found: " + time));
                }
                Utils.appendCSVRecord(chunkData, rec);
            } else {
                event = new SplunkEvent(metadata, rec);
                while (!this.eventCache.offer(event)) {
                    try {
                        logger.warn((Object)"Event cache full capacity hence waiting before retrying");
                        Thread.sleep(100L);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Error while sleeping");
                    }
                }
            }
            first = false;
            ++eventCount;
            lastRec = rec;
        }
        SplunkEventChunk chunk = null;
        if (eventCount == 0) {
            logger.error((Object)"Did not receive any events from splunkd");
            if (lastChunk && eventing) {
                String compressed = Utils.compressAndEncode("");
                chunk = new SplunkEventChunk(this.hostName, 0L, Long.MAX_VALUE, compressed, 0, Utils.compressAndEncode(infoCsvContent), sparkLookupCode, true);
                logger.debug((Object)("Event chunk received from splunkd: " + chunk));
            }
        } else if (eventCount > 0 && eventing) {
            long time;
            SplunkEvent lastEvent = new SplunkEvent(metadata, lastRec);
            String timeStr = (String)lastEvent.get("_time");
            long endTime = time = Float.valueOf(timeStr).longValue();
            logger.debug((Object)("End time found: " + endTime));
            String compressed = Utils.compressAndEncode(chunkData.toString());
            chunk = new SplunkEventChunk(this.hostName, startTime, endTime, compressed, eventCount, Utils.compressAndEncode(infoCsvContent), sparkLookupCode, lastChunk);
            logger.debug((Object)("Event chunk received from splunkd: " + chunk));
        }
        if (chunk != null) {
            while (!this.chunkCache.offer(chunk)) {
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable t) {
                    logger.error((Object)"Error while sleeping");
                }
            }
            logger.error((Object)("added event chunk to cache" + chunk));
        }
        if (eventCount > 0 && !eventing) {
            logger.info((Object)("Number of events read from splunkd and added to event cache: " + eventCount));
        }
        String dataResponse = Utils.toCSVString(metadata);
        if (lastChunk) {
            this.finished = true;
            logger.info((Object)("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! all events are collected from splunkd, waiting for dispatchers to end; time taken to read events from splunkd: " + this.fromSplunkd + " millis"));
            while (!this.chunkCache.isEmpty()) {
                Utils.sleep(100L);
            }
            logger.info((Object)"Chunk cache is empty so all chunks are currently being sent, hence will try shutting down executor service");
            ses.shutdown();
            logger.info((Object)"Waiting for executor service to shutdown");
            block10: while (true) {
                try {
                    while (true) {
                        boolean ret;
                        if (ret = ses.awaitTermination(10L, TimeUnit.SECONDS)) {
                            logger.info((Object)"Executor service terminated hence breaking");
                            break block10;
                        }
                        logger.debug((Object)"All chunks are still not sent over since executor service is still running");
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)"error occurred during await termination, will retry", t);
                    continue;
                }
                break;
            }
            logger.error((Object)"executor service is now shutdown and all events dispatched");
            logger.error((Object)"Sending EOF to splunkd which will kill this process");
            dataResponse = "\n<EOF>";
        }
        String responseHeader = "chunked 1.0,0," + dataResponse.length();
        bw.write(responseHeader + "\n");
        bw.write(dataResponse);
        bw.flush();
        parser.close();
        long elapsed = System.currentTimeMillis() - start;
        logger.info((Object)("Completed processing execute event chunk from splunkd " + elapsed + " millis; time to parse: " + timeToParse + " millis"));
        this.fromSplunkd += elapsed;
    }

    static {
        PropertyConfigurator.configure((String)(System.getenv("DFS_HOME") + "/spark-1.6.0-bin-hadoop2.6/conf/log4j.properties"));
        logger = Logger.getLogger(ParallelExportProcessor.class);
    }
}

