/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.Entity;
import com.splunk.EntityCollection;
import com.splunk.Event;
import com.splunk.Job;
import com.splunk.JobArgs;
import com.splunk.JobCollection;
import com.splunk.RequestMessage;
import com.splunk.ResponseMessage;
import com.splunk.ResultsReaderXml;
import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import com.splunk.commons.search.HostPort;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.sdk.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class FSHSplunkConnectionHandler
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(FSHSplunkConnectionHandler.class);
    private static long conCounter = 1L;
    private static HashMap<String, SplunkConnectionHandler> connectionHandlerMap = new HashMap();

    public static String getVersion(String conId) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(conId);
        if (connectionHandler == null) {
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", conId));
        }
        return connectionHandler.getRemoteVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNewConnection(SplunkSearchEndpoint sse) {
        HashMap<String, SplunkConnectionHandler> hashMap = connectionHandlerMap;
        synchronized (hashMap) {
            String connectionId = String.format("Connection_%d", conCounter);
            SplunkConnectionHandler connectionHandler = new SplunkConnectionHandler(sse);
            ++conCounter;
            connectionHandlerMap.put(connectionId, connectionHandler);
            return connectionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupConnection(String connectionId) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
        if (connectionHandler == null) {
            logger.error((Object)("Connection id " + connectionId + " nonexistant i cleanup"));
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
        }
        HashMap<String, SplunkConnectionHandler> hashMap = connectionHandlerMap;
        synchronized (hashMap) {
            if (connectionHandler.close()) {
                connectionHandlerMap.remove(connectionId);
                logger.info((Object)"All connections are done, so removing from the connection map");
            }
        }
    }

    public static Pair<String, Job> triggerPartitionedQuery(String fshRemoteSid, String originalUser, String conId, String searchToExecute, List<HostPort> toSendIP) {
        logger.info((Object)"Entering triggerPartitionedQuery");
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(conId);
        if (connectionHandler == null) {
            logger.error((Object)("Connection id " + conId + " nonexistant i triggerPartitionedQuery"));
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", conId));
        }
        return connectionHandler.triggerPartitionedQuery(fshRemoteSid, originalUser, searchToExecute, toSendIP);
    }

    public static Pair<String, Job> triggerNonPartitionedQuery(String fshRemoteSid, String conId, String searchToExecute) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(conId);
        if (connectionHandler == null) {
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", conId));
        }
        return connectionHandler.triggerNonPartitionedQuery(fshRemoteSid, searchToExecute);
    }

    public static int getChunkSize(String connectionId) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
        if (connectionHandler == null) {
            logger.error((Object)("Connection id " + connectionId + " nonexistant i getChunkSize"));
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
        }
        return connectionHandler.getChunkSize();
    }

    public static String getAST(String connectionId, String search) throws Exception {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
        if (connectionHandler == null) {
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
        }
        return connectionHandler.getAST(search);
    }

    public static Long getEstimatedEventCount(String connectionId, String searchForEstimation) throws Exception {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
        if (connectionHandler == null) {
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
        }
        return connectionHandler.getEstimatedEventCount(searchForEstimation);
    }

    private static class SplunkConnectionHandler {
        private final String user;
        private final String password;
        private final String host;
        private final int port;
        private String queryToFire;
        private Service service;
        private Integer numberOfConnections;

        SplunkConnectionHandler(SplunkSearchEndpoint sse) {
            this.user = sse.getUser();
            this.password = sse.getPassword();
            this.queryToFire = sse.getSPL();
            this.host = sse.getHost();
            this.port = sse.getPort();
            this.service = null;
            this.numberOfConnections = 0;
        }

        private void connect() {
            ServiceArgs serviceArgs = new ServiceArgs();
            serviceArgs.setUsername(this.user);
            serviceArgs.setPassword(this.password);
            serviceArgs.setHost(this.host);
            serviceArgs.setPort(this.port);
            serviceArgs.setSSLSecurityProtocol(SSLSecurityProtocol.TLSv1_2);
            this.service = Service.connect((Map)serviceArgs);
        }

        public String getRemoteVersion() {
            if (this.service == null) {
                this.connect();
            }
            return this.service.version;
        }

        public int getChunkSize() {
            Entity restApi = (Entity)((EntityCollection)this.service.getConfs().get((Object)"limits")).get((Object)"restapi");
            return Integer.parseInt((String)restApi.get((Object)"maxresultrows"));
        }

        private Pair<String, Job> triggerNonPartitionedQuery(String fshRemoteSid, String searchToExecute) {
            if (this.service == null) {
                this.connect();
            }
            Integer n = this.numberOfConnections;
            Integer n2 = this.numberOfConnections = Integer.valueOf(this.numberOfConnections + 1);
            JobCollection jobs = this.service.getJobs();
            JobArgs jobArgs = new JobArgs();
            if (fshRemoteSid != null) {
                jobArgs.setId(fshRemoteSid);
            }
            jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
            jobArgs.setMaximumCount(Integer.MAX_VALUE);
            jobArgs.setAutoCancel(0);
            this.queryToFire = searchToExecute;
            Job job = jobs.create(this.queryToFire, jobArgs);
            String sid = job.getSid();
            logger.info((Object)String.format("Triggering non-partitioned search on remote SH=%s port=%d user=%s password=***** search=%s sid=%s", this.host, this.port, this.user, this.queryToFire, sid));
            return new Pair<String, Job>(sid, job);
        }

        private Pair<String, Job> triggerPartitionedQuery(String fshRemoteSid, String originalUser, String searchToExecute, List<HostPort> toIpList) {
            if (this.service == null) {
                this.connect();
            }
            Integer n = this.numberOfConnections;
            Integer n2 = this.numberOfConnections = Integer.valueOf(this.numberOfConnections + 1);
            JobCollection jobs = this.service.getJobs();
            JobArgs jobArgs = new JobArgs();
            if (fshRemoteSid != null) {
                jobArgs.setId(fshRemoteSid);
            }
            jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
            jobArgs.setMaximumCount(Integer.MAX_VALUE);
            jobArgs.setAutoCancel(0);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < toIpList.size(); ++i) {
                sb.append(toIpList.get(i).toString());
                if (i == toIpList.size() - 1) continue;
                sb.append(",");
            }
            String workerlist = sb.toString();
            jobArgs.put((Object)"workers", (Object)workerlist);
            jobArgs.put((Object)"partition_method", (Object)"vpc");
            jobArgs.put((Object)"original_user", (Object)originalUser);
            Job job = jobs.create(searchToExecute, jobArgs);
            String sid = job.getSid();
            logger.info((Object)String.format("Triggering partitioned search on remote SH=%s port=%d user=%s password=***** search=%s sid=%s", this.host, this.port, this.user, searchToExecute, sid));
            return new Pair<String, Job>(sid, job);
        }

        public String getAST(String search) throws Exception {
            JSONObject param = new JSONObject();
            param.put("spl", (Object)search);
            JSONArray array = new JSONArray();
            array.put((Object)new JSONObject().put("name", (Object)"inline_savedsearch"));
            array.put((Object)new JSONObject().put("name", (Object)"inline_datamodel"));
            array.put((Object)new JSONObject().put("name", (Object)"expand_search"));
            array.put((Object)new JSONObject().put("name", (Object)"inline_from"));
            array.put((Object)new JSONObject().put("name", (Object)"enable_dfs"));
            param.put("actions", (Object)array);
            RequestMessage request = new RequestMessage("POST");
            request.getHeader().put("Content-Type", "application/x-www-form-urlencoded");
            request.setContent(param.toString());
            ResponseMessage response = this.service.send("search/ast", request);
            return this.inputStreamToString(response.getContent());
        }

        private String inputStreamToString(InputStream stream) throws IOException {
            String tmp;
            StringBuilder b = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((tmp = reader.readLine()) != null) {
                b.append(tmp + "\n");
            }
            return b.toString();
        }

        public Long getEstimatedEventCount(String searchForEstimation) throws Exception {
            Event event;
            if (this.service == null) {
                this.connect();
            }
            JobCollection jobs = this.service.getJobs();
            JobArgs jobArgs = new JobArgs();
            jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
            jobArgs.setMaximumCount(Integer.MAX_VALUE);
            jobArgs.setAutoCancel(0);
            Long estimatedEventCount = 0L;
            Job job = jobs.create(searchForEstimation, jobArgs);
            String sid = job.getSid();
            logger.info((Object)String.format("Triggering estimation search on remote SH=%s port=%d user=%s password=***** search=%s sid=%s", this.host, this.port, this.user, searchForEstimation, sid));
            while (!job.isDone()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            InputStream resultsNormalSearch = job.getResults();
            ResultsReaderXml resultsReaderNormalSearch = new ResultsReaderXml(resultsNormalSearch);
            while ((event = resultsReaderNormalSearch.getNextEvent()) != null) {
                for (String key : event.keySet()) {
                    if (!key.equalsIgnoreCase("count")) continue;
                    estimatedEventCount = estimatedEventCount + (long)Integer.parseInt((String)event.get(key));
                }
            }
            return estimatedEventCount;
        }

        public boolean close() {
            Integer n = this.numberOfConnections;
            Integer n2 = this.numberOfConnections = Integer.valueOf(this.numberOfConnections - 1);
            if (this.numberOfConnections == 0) {
                this.service.logout();
                return true;
            }
            if (this.numberOfConnections < 0) {
                throw new IllegalStateException("Trying to close an already closed connection");
            }
            return false;
        }
    }
}

