/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.util.HashMap;
import java.util.Map;

public enum DFSSearchState {
    INIT(0),
    RUN(1),
    PAUSE(2),
    CANCEL(3),
    FINALIZE(4),
    STOP(5);

    public final int finalId;
    private static Map<Integer, DFSSearchState> lookupCache;
    private static boolean isCacheFilled;

    private DFSSearchState(int id) {
        this.finalId = id;
    }

    private static void lazyFillCache() {
        HashMap<Integer, DFSSearchState> localC = new HashMap<Integer, DFSSearchState>();
        for (DFSSearchState searchStatus : DFSSearchState.values()) {
            localC.put(searchStatus.finalId, searchStatus);
        }
        lookupCache = localC;
        isCacheFilled = true;
    }

    public static DFSSearchState getSearchState(int lookupVal) {
        if (!isCacheFilled) {
            DFSSearchState.lazyFillCache();
        }
        return lookupCache.get(lookupVal);
    }

    static {
        lookupCache = null;
        isCacheFilled = false;
    }
}

