/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import org.json.JSONObject;

public class DFCParams {
    private final String dfcTitle;
    private final String dfcId;
    private final int dfcPort;
    private final int dfcReceiverPort;
    private final int dfcReceiverPortCount;
    private final int dfmMasterPort;
    private final String sid;
    private final int dfcNumCores;
    private final int dfcNumExecutors;
    private final int dfcExecutorMemMbs;
    private final int dfcDriverMemMbs;
    private final int dfcCoresPerExecutor;
    private final int dfcNumConcurrentSearches;
    private final long maxReducePartitionSize;
    private final String splunkConf;
    private final String splunkVersion;
    private final String extraKryoClasses;

    public DFCParams(String dfcTitle, String dfcId, int dfcPort, long maxReducePartitionSize, int dfcReceiverPort, int dfcReceiverPortCount, int dfmMasterPort, String sid, int dfcNumCores, int dfcNumExecutors, int dfcExecutorMemMbs, int dfcDriverMemMbs, int dfcCoresPerExecutor, int dfcNumConcurrentSearches, String splunkVersion, String extraKryoClasses, String splunkConf) {
        this.dfcTitle = dfcTitle;
        this.dfcId = dfcId;
        this.dfcPort = dfcPort;
        this.maxReducePartitionSize = maxReducePartitionSize;
        this.dfcReceiverPort = dfcReceiverPort;
        this.dfcReceiverPortCount = dfcReceiverPortCount;
        this.dfmMasterPort = dfmMasterPort;
        this.sid = sid;
        this.dfcNumCores = dfcNumCores;
        this.dfcNumExecutors = dfcNumExecutors;
        this.dfcExecutorMemMbs = dfcExecutorMemMbs;
        this.dfcDriverMemMbs = dfcDriverMemMbs;
        this.dfcCoresPerExecutor = dfcCoresPerExecutor;
        this.dfcNumConcurrentSearches = dfcNumConcurrentSearches;
        this.splunkConf = splunkConf;
        this.splunkVersion = splunkVersion;
        this.extraKryoClasses = extraKryoClasses;
    }

    public String getExtraKryoClasses() {
        return this.extraKryoClasses;
    }

    public String getDfcTitle() {
        return this.dfcTitle;
    }

    public String getDfcId() {
        return this.dfcId;
    }

    public int getDfcPort() {
        return this.dfcPort;
    }

    public long getMaxReducePartitionSize() {
        return this.maxReducePartitionSize;
    }

    public int getDfcReceiverPort() {
        return this.dfcReceiverPort;
    }

    public int getDfcReceiverPortCount() {
        return this.dfcReceiverPortCount;
    }

    public int getDfmMasterPort() {
        return this.dfmMasterPort;
    }

    public String getSid() {
        return this.sid;
    }

    public int getDfcNumCores() {
        return this.dfcNumCores;
    }

    public int getDfcNumExecutors() {
        return this.dfcNumExecutors;
    }

    public int getDfcExecutorMemMbs() {
        return this.dfcExecutorMemMbs;
    }

    public int getDfcDriverMemMbs() {
        return this.dfcDriverMemMbs;
    }

    public int getDfcNumConcurrentSearches() {
        return this.dfcNumConcurrentSearches;
    }

    public String getSplunkConf() {
        return this.splunkConf;
    }

    public String getSplunkVersion() {
        return this.splunkVersion;
    }

    public String toString() {
        return String.format("{ dfcTitle:\"%s\", dfcId:\"%s\", dfcPort:%d, maxReducePartitionSize: %d , dfcReceiverPort:%d, dfcReceiverPortCount:%d, dfmMasterPort:%d, sid:\"%s\", dfcNumCores:%d, dfcNumExecutors:%d, dfcExecutorMemMbs:%d, dfcDriverMemMbs: %d, dfcCoresPerExecutor: %d, dfcNumConcurrentSearches: %d , splunkVersion:%s" + (this.hasExtraKryoClasses() ? ", extraKryoClasses:%s" : "%s") + ", " + "splunkConf" + ": %s }", this.dfcTitle, this.dfcId, this.dfcPort, this.maxReducePartitionSize, this.dfcReceiverPort, this.dfcReceiverPortCount, this.dfmMasterPort, this.sid, this.dfcNumCores, this.dfcNumExecutors, this.dfcExecutorMemMbs, this.dfcDriverMemMbs, this.dfcCoresPerExecutor, this.dfcNumConcurrentSearches, this.splunkVersion, this.hasExtraKryoClasses() ? "\"" + this.extraKryoClasses + "\"" : "", this.splunkConf);
    }

    public String toJson() {
        return this.toString();
    }

    public static DFCParams fromJson(String json) {
        JSONObject jsonObj = new JSONObject(json);
        String dfcTitle = jsonObj.getString("dfcTitle");
        String dfcId = jsonObj.getString("dfcId");
        int dfcPort = jsonObj.getInt("dfcPort");
        long maxReducePartitionSize = jsonObj.getLong("maxReducePartitionSize");
        int dfcReceiverPort = jsonObj.getInt("dfcReceiverPort");
        int dfcReceiverPortCount = jsonObj.getInt("dfcReceiverPortCount");
        int dfmMasterPort = jsonObj.getInt("dfmMasterPort");
        String sid = jsonObj.getString("sid");
        int dfcNumCores = jsonObj.getInt("dfcNumCores");
        int dfcNumExecutors = jsonObj.getInt("dfcNumExecutors");
        int dfcExecutorMemMbs = jsonObj.getInt("dfcExecutorMemMbs");
        int dfcDriverMemMbs = jsonObj.getInt("dfcDriverMemMbs");
        int dfcCoresPerExecutor = jsonObj.getInt("dfcCoresPerExecutor");
        int dfcNumConcurrentSearches = jsonObj.getInt("dfcNumConcurrentSearches");
        String splunkVersion = jsonObj.getString("splunkVersion");
        String extraKryoClasses = jsonObj.has("extraKryoClasses") ? jsonObj.getString("extraKryoClasses") : null;
        String splunkConf = jsonObj.getJSONObject("splunkConf").toString();
        return new DFCParams(dfcTitle, dfcId, dfcPort, maxReducePartitionSize, dfcReceiverPort, dfcReceiverPortCount, dfmMasterPort, sid, dfcNumCores, dfcNumExecutors, dfcExecutorMemMbs, dfcDriverMemMbs, dfcCoresPerExecutor, dfcNumConcurrentSearches, splunkVersion, extraKryoClasses, splunkConf);
    }

    private boolean hasExtraKryoClasses() {
        return this.extraKryoClasses != null && !"".equals(this.extraKryoClasses.trim());
    }
}

