/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteQueryUsingAggregateIndex;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

public final class RewriteQueryUsingAggregateIndexCtx
implements NodeProcessorCtx {
    private Map<Operator<? extends OperatorDesc>, OpParseContext> opc = new LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext>();
    private final Hive hiveDb;
    private final ParseContext parseContext;
    private GenericUDAFEvaluator eval = null;
    private final String indexTableName;
    private final String baseTableName;
    private final String aggregateFunction;
    private ExprNodeColumnDesc aggrExprNode = null;

    private RewriteQueryUsingAggregateIndexCtx(ParseContext parseContext, Hive hiveDb, String indexTableName, String baseTableName, String aggregateFunction) {
        this.parseContext = parseContext;
        this.hiveDb = hiveDb;
        this.indexTableName = indexTableName;
        this.baseTableName = baseTableName;
        this.aggregateFunction = aggregateFunction;
        this.opc = parseContext.getOpParseCtx();
    }

    public static RewriteQueryUsingAggregateIndexCtx getInstance(ParseContext parseContext, Hive hiveDb, String indexTableName, String baseTableName, String aggregateFunction) {
        return new RewriteQueryUsingAggregateIndexCtx(parseContext, hiveDb, indexTableName, baseTableName, aggregateFunction);
    }

    public Map<Operator<? extends OperatorDesc>, OpParseContext> getOpc() {
        return this.opc;
    }

    public ParseContext getParseContext() {
        return this.parseContext;
    }

    public Hive getHiveDb() {
        return this.hiveDb;
    }

    public String getIndexName() {
        return this.indexTableName;
    }

    public GenericUDAFEvaluator getEval() {
        return this.eval;
    }

    public void setEval(GenericUDAFEvaluator eval) {
        this.eval = eval;
    }

    public void setAggrExprNode(ExprNodeColumnDesc aggrExprNode) {
        this.aggrExprNode = aggrExprNode;
    }

    public ExprNodeColumnDesc getAggrExprNode() {
        return this.aggrExprNode;
    }

    public void invokeRewriteQueryProc(Operator<? extends OperatorDesc> topOp) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), RewriteQueryUsingAggregateIndex.getReplaceTableScanProc());
        opRules.put(new RuleRegExp("R2", SelectOperator.getOperatorName() + "%"), RewriteQueryUsingAggregateIndex.getNewQuerySelectSchemaProc());
        opRules.put(new RuleRegExp("R3", GroupByOperator.getOperatorName() + "%"), RewriteQueryUsingAggregateIndex.getNewQueryGroupbySchemaProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, this);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.add(topOp);
        ogw.startWalking(topNodes, null);
    }

    private NodeProcessor getDefaultProc() {
        return new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public String getAggregateFunction() {
        return this.aggregateFunction;
    }
}

